/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.SupportedOption;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.annotations.Option;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.states.CCDsPowerState;

public class RebPowerOnOffCommands {
    private static final Logger LOG = Logger.getLogger(RebPowerOnOffCommands.class.getName());
    private final SupportedOption dryRunOption = SupportedOption.getSupportedOption((String)"dryRun");
    private final FocalPlaneSubsystem focalPlane;
    private final AgentStateService agentStateService;

    RebPowerOnOffCommands(FocalPlaneSubsystem focalPlane) {
        this.focalPlane = focalPlane;
        this.agentStateService = (AgentStateService)focalPlane.getAgentService(AgentStateService.class);
    }

    @Option(name="dryRun", description="If set to true the command will not execute any commands on the Rebs")
    @Command(description="Power on a specified set of Rebs", type=Command.CommandType.ACTION, level=20, autoAck=false)
    public void powerOnCCDs(Options options, @Argument(description="Regular expression to match the rebs by path.") String regEx, @Argument(description="Number of seconds to wait between rebs [3:20]") double delay) throws RaftException {
        Pattern rebPattern = Pattern.compile(regEx);
        boolean dryRun = options.hasOption(this.dryRunOption);
        ArrayList<String> rebs = new ArrayList<String>();
        ArrayList<String> cornerRebs = new ArrayList<String>();
        ArrayList<String> onRebs = new ArrayList<String>();
        for (Map.Entry<String, REBDevice> e : this.focalPlane.getRebDevices().entrySet()) {
            String rebPath = e.getKey();
            if (!rebPattern.matcher(rebPath).matches()) continue;
            if (rebPath.endsWith("G") || rebPath.endsWith("W")) {
                cornerRebs.add(rebPath);
                continue;
            }
            if (this.agentStateService.isComponentInState(rebPath, (Enum)CCDsPowerState.ON)) {
                onRebs.add(rebPath);
                continue;
            }
            rebs.add(rebPath);
        }
        double rebPowerOnSeconds = 1.0;
        Duration duration = rebs.isEmpty() ? Duration.ofSeconds(1L) : Duration.ofSeconds((long)(1.3 * ((double)rebs.size() * rebPowerOnSeconds + (double)(rebs.size() - 1) * delay)));
        this.focalPlane.helper().precondition(delay >= 3.0 && delay <= 20.0, "Power on delay must be in range [3:20]", new Supplier[0]).duration(duration).action(() -> {
            if (!cornerRebs.isEmpty() || !onRebs.isEmpty()) {
                StringBuilder skippingRebs = new StringBuilder("The following Rebs are skipped:\n");
                if (!cornerRebs.isEmpty()) {
                    skippingRebs.append("non-science rebs: ").append(cornerRebs).append("\n");
                }
                if (!onRebs.isEmpty()) {
                    skippingRebs.append("already on rebs: ").append(onRebs).append("\n");
                }
                LOG.log(Level.INFO, skippingRebs.toString());
            }
            if (rebs.isEmpty()) {
                LOG.log(Level.INFO, "There are no rebs to be powered on that match the provided regular expression {0}", rebPattern);
                return;
            }
            LOG.log(Level.INFO, "Execuring powerOnCCDs for the following Rebs:\n  {0}\nBetween each reb there will be a {1} seconds pause.\nDry Run = {2}", new Object[]{rebs, delay, dryRun});
            int count = 0;
            for (String rebPath : rebs) {
                ++count;
                REBDevice device = this.focalPlane.getRebDevices().get(rebPath);
                LOG.log(Level.INFO, "Invoking powerCCDsOn on Reb: {0}", rebPath);
                if (!dryRun) {
                    device.powerCCDsOn();
                }
                if (count == rebs.size()) continue;
                LOG.log(Level.INFO, "Sleep for {0} seconds", delay);
                if (dryRun) continue;
                try {
                    Thread.sleep((long)(delay * 1000.0));
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    @Option(name="dryRun", description="If set to true the command will not execute any commands on the Rebs")
    @Command(description="Power off a specified set of Rebs", type=Command.CommandType.ACTION, level=20, autoAck=false)
    public void powerOffCCDs(Options options, @Argument(description="Regular expression to match the rebs by path.") String regEx, @Argument(description="Number of seconds to wait between rebs [0.5:5]") double delay) throws RaftException {
        Pattern rebPattern = Pattern.compile(regEx);
        boolean dryRun = options.hasOption(this.dryRunOption);
        ArrayList<String> rebs = new ArrayList<String>();
        ArrayList<String> cornerRebs = new ArrayList<String>();
        ArrayList<String> offRebs = new ArrayList<String>();
        for (Map.Entry<String, REBDevice> e : this.focalPlane.getRebDevices().entrySet()) {
            String rebPath = e.getKey();
            if (!rebPattern.matcher(rebPath).matches()) continue;
            if (rebPath.endsWith("G") || rebPath.endsWith("W")) {
                cornerRebs.add(rebPath);
                continue;
            }
            if (this.agentStateService.isComponentInState(rebPath, (Enum)CCDsPowerState.OFF)) {
                offRebs.add(rebPath);
                continue;
            }
            rebs.add(rebPath);
        }
        double rebPowerOffSeconds = 1.0;
        Duration duration = rebs.isEmpty() ? Duration.ofSeconds(1L) : Duration.ofSeconds((long)(1.3 * ((double)rebs.size() * rebPowerOffSeconds + (double)(rebs.size() - 1) * delay)));
        this.focalPlane.helper().precondition(delay >= 0.5 && delay <= 5.0, "Power off delay must be in range [0.5:5]", new Supplier[0]).duration(duration).action(() -> {
            if (!cornerRebs.isEmpty() || !offRebs.isEmpty()) {
                StringBuilder skippingRebs = new StringBuilder("The following Rebs are skipped:\n");
                if (!cornerRebs.isEmpty()) {
                    skippingRebs.append("non-science rebs: ").append(cornerRebs).append("\n");
                }
                if (!offRebs.isEmpty()) {
                    skippingRebs.append("already off rebs: ").append(offRebs).append("\n");
                }
                LOG.log(Level.INFO, skippingRebs.toString());
            }
            if (rebs.isEmpty()) {
                LOG.log(Level.INFO, "There are no rebs to be powered off that match the provided regular expression {0}", rebPattern);
                return;
            }
            LOG.log(Level.INFO, "Execuring powerOffCCDs for the following Rebs:\n  {0}\nBetween each reb there will be a {1} seconds pause.\nDry Run = {2}", new Object[]{rebs, delay, dryRun});
            int count = 0;
            for (String rebPath : rebs) {
                ++count;
                REBDevice device = this.focalPlane.getRebDevices().get(rebPath);
                LOG.log(Level.INFO, "Invoking powerCCDsOff on Reb: {0}", rebPath);
                if (!dryRun) {
                    device.powerCCDsOff();
                }
                if (count == rebs.size()) continue;
                LOG.log(Level.INFO, "Sleep for {0} seconds", delay);
                if (dryRun) continue;
                try {
                    Thread.sleep((long)(delay * 1000.0));
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    @Option(name="dryRun", description="If set to true the command will not execute any commands on the Rebs")
    @Command(description="Power off a specified set of Rebs", type=Command.CommandType.ACTION, level=20, autoAck=false)
    public void shortsTestCCDs(Options options, @Argument(description="Regular expression to match the rebs by path.") String regEx, @Argument(description="Number of seconds to wait between rebs [2:20]") double delay) throws RaftException {
        Pattern rebPattern = Pattern.compile(regEx);
        boolean dryRun = options.hasOption(this.dryRunOption);
        ArrayList<String> rebs = new ArrayList<String>();
        ArrayList<String> cornerRebs = new ArrayList<String>();
        for (Map.Entry<String, REBDevice> e : this.focalPlane.getRebDevices().entrySet()) {
            String rebPath = e.getKey();
            if (!rebPattern.matcher(rebPath).matches()) continue;
            if (rebPath.endsWith("G") || rebPath.endsWith("W")) {
                cornerRebs.add(rebPath);
                continue;
            }
            rebs.add(rebPath);
        }
        double rebShortsTestSeconds = 1.0;
        Duration duration = rebs.isEmpty() ? Duration.ofSeconds(1L) : Duration.ofSeconds((long)(1.3 * ((double)rebs.size() * rebShortsTestSeconds + (double)(rebs.size() - 1) * delay)));
        this.focalPlane.helper().precondition(delay >= 2.0 && delay <= 20.0, "Shorts test delay must be in range [2:20]", new Supplier[0]).duration(duration).action(() -> {
            if (!cornerRebs.isEmpty()) {
                StringBuilder skippingRebs = new StringBuilder("The following Rebs are skipped:\n");
                skippingRebs.append("non-science rebs: ").append(cornerRebs).append("\n");
                LOG.log(Level.INFO, skippingRebs.toString());
            }
            if (rebs.isEmpty()) {
                LOG.log(Level.INFO, "There are no rebs to test for shorts that match the provided regular expression {0}", rebPattern);
                return;
            }
            LOG.log(Level.INFO, "Execuring testCCDShorts for the following Rebs:\n  {0}\nBetween each reb there will be a {1} seconds pause.\nDry Run = {2}", new Object[]{rebs, delay, dryRun});
            int count = 0;
            for (String rebPath : rebs) {
                ++count;
                REBDevice device = this.focalPlane.getRebDevices().get(rebPath);
                LOG.log(Level.INFO, "Invoking testCCDShorts on Reb: {0}", rebPath);
                if (!dryRun) {
                    device.testCCDShorts();
                }
                if (count == rebs.size()) continue;
                LOG.log(Level.INFO, "Sleep for {0} seconds", delay);
                if (dryRun) continue;
                try {
                    Thread.sleep((long)(delay * 1000.0));
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    @Option(name="dryRun", description="If set to true the command will not execute any commands on the Rebs")
    @Command(description="Close the back bias switch for a specified set of Rebs", type=Command.CommandType.ACTION, level=20, autoAck=false)
    public void closeBackBiasSwitches(Options options, @Argument(description="Regular expression to match the rebs by path.") String regEx, @Argument(description="Number of seconds to wait between rebs [1:5]") double delay) throws RaftException {
        Pattern rebPattern = Pattern.compile(regEx);
        boolean dryRun = options.hasOption(this.dryRunOption);
        ArrayList<String> rebs = new ArrayList<String>();
        ArrayList<String> cornerRebs = new ArrayList<String>();
        ArrayList<String> onRebs = new ArrayList<String>();
        for (Map.Entry<String, REBDevice> e : this.focalPlane.getRebDevices().entrySet()) {
            String rebPath = e.getKey();
            if (!rebPattern.matcher(rebPath).matches()) continue;
            if (rebPath.endsWith("G") || rebPath.endsWith("W")) {
                cornerRebs.add(rebPath);
                continue;
            }
            if (e.getValue().isBackBiasOn()) {
                onRebs.add(rebPath);
                continue;
            }
            rebs.add(rebPath);
        }
        double closeBackBiasSwitchSeconds = 1.0;
        Duration duration = rebs.isEmpty() ? Duration.ofSeconds(1L) : Duration.ofSeconds((long)(1.3 * ((double)rebs.size() * closeBackBiasSwitchSeconds + (double)(rebs.size() - 1) * delay)));
        this.focalPlane.helper().precondition(delay >= 1.0 && delay <= 5.0, "Close back bias delay must be in range [1:5]", new Supplier[0]).duration(duration).action(() -> {
            if (!cornerRebs.isEmpty() || !onRebs.isEmpty()) {
                StringBuilder skippingRebs = new StringBuilder("The following Rebs are skipped:\n");
                if (!cornerRebs.isEmpty()) {
                    skippingRebs.append("non-science rebs: ").append(cornerRebs).append("\n");
                }
                if (!onRebs.isEmpty()) {
                    skippingRebs.append("switch already closed for rebs: ").append(onRebs).append("\n");
                }
                LOG.log(Level.INFO, skippingRebs.toString());
            }
            if (rebs.isEmpty()) {
                LOG.log(Level.INFO, "There are no switches that need to be closed for the provided regular expression {0}", rebPattern);
                return;
            }
            LOG.log(Level.INFO, "Execuring setBackBias(true) for the following Rebs:\n  {0}\nBetween each reb there will be a {1} seconds pause.\nDry Run = {2}", new Object[]{rebs, delay, dryRun});
            int count = 0;
            for (String rebPath : rebs) {
                ++count;
                REBDevice device = this.focalPlane.getRebDevices().get(rebPath);
                LOG.log(Level.INFO, "Invoking setBackBias(true) on Reb: {0}", rebPath);
                if (!dryRun) {
                    device.setBackBias(true);
                }
                if (count == rebs.size()) continue;
                LOG.log(Level.INFO, "Sleep for {0} seconds", delay);
                if (dryRun) continue;
                try {
                    Thread.sleep((long)(delay * 1000.0));
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    @Option(name="dryRun", description="If set to true the command will not execute any commands on the Rebs")
    @Command(description="Open the back bias switch for a specified set of Rebs", type=Command.CommandType.ACTION, level=20, autoAck=false)
    public void openBackBiasSwitches(Options options, @Argument(description="Regular expression to match the rebs by path.") String regEx, @Argument(description="Number of seconds to wait between rebs [0.1:5]") double delay) throws RaftException {
        Pattern rebPattern = Pattern.compile(regEx);
        boolean dryRun = options.hasOption(this.dryRunOption);
        ArrayList<String> rebs = new ArrayList<String>();
        ArrayList<String> cornerRebs = new ArrayList<String>();
        ArrayList<String> offRebs = new ArrayList<String>();
        for (Map.Entry<String, REBDevice> e : this.focalPlane.getRebDevices().entrySet()) {
            String rebPath = e.getKey();
            if (!rebPattern.matcher(rebPath).matches()) continue;
            if (rebPath.endsWith("G") || rebPath.endsWith("W")) {
                cornerRebs.add(rebPath);
                continue;
            }
            if (!e.getValue().isBackBiasOn()) {
                offRebs.add(rebPath);
                continue;
            }
            rebs.add(rebPath);
        }
        double openBackBiasSwitchSeconds = 1.0;
        Duration duration = rebs.isEmpty() ? Duration.ofSeconds(1L) : Duration.ofSeconds((long)(1.3 * ((double)rebs.size() * openBackBiasSwitchSeconds + (double)(rebs.size() - 1) * delay)));
        this.focalPlane.helper().precondition(delay >= 0.1 && delay <= 5.0, "Open back bias delay must be in range [0.1:5]", new Supplier[0]).duration(duration).action(() -> {
            if (!cornerRebs.isEmpty() || !offRebs.isEmpty()) {
                StringBuilder skippingRebs = new StringBuilder("The following Rebs are skipped:\n");
                if (!cornerRebs.isEmpty()) {
                    skippingRebs.append("non-science rebs: ").append(cornerRebs).append("\n");
                }
                if (!offRebs.isEmpty()) {
                    skippingRebs.append("switch already open for rebs: ").append(offRebs).append("\n");
                }
                LOG.log(Level.INFO, skippingRebs.toString());
            }
            if (rebs.isEmpty()) {
                LOG.log(Level.INFO, "There are no switches that need to be opened for the provided regular expression {0}", rebPattern);
                return;
            }
            LOG.log(Level.INFO, "Execuring setBackBias(false) for the following Rebs:\n  {0}\nBetween each reb there will be a {1} seconds pause.\nDry Run = {2}", new Object[]{rebs, delay, dryRun});
            int count = 0;
            for (String rebPath : rebs) {
                ++count;
                REBDevice device = this.focalPlane.getRebDevices().get(rebPath);
                LOG.log(Level.INFO, "Invoking setBackBias(false) on Reb: {0}", rebPath);
                if (!dryRun) {
                    device.setBackBias(false);
                }
                if (count == rebs.size()) continue;
                LOG.log(Level.INFO, "Sleep for {0} seconds", delay);
                if (dryRun) continue;
                try {
                    Thread.sleep((long)(delay * 1000.0));
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }
}

