/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.guider;

import java.time.Instant;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.SensorLocation;

public class StateMetaData {
    private final State state;
    private final Status status;
    private final long sequence;
    private final Instant timestamp;
    private final SensorLocation sensorLocation;

    private StateMetaData(int type, int status, int sequence, long timestampNanos, byte bay, byte board, int sensor) {
        this.state = State.values()[type];
        this.status = Status.values()[status];
        this.sequence = sequence;
        this.timestamp = Instant.ofEpochSecond(timestampNanos / 1000000000L, timestampNanos % 1000000000L);
        this.sensorLocation = new SensorLocation(new Location((int)bay, (int)board), sensor);
    }

    public State getState() {
        return this.state;
    }

    public Status getStatus() {
        return this.status;
    }

    public long getSequence() {
        return this.sequence;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public SensorLocation getSensorLocation() {
        return this.sensorLocation;
    }

    public String toString() {
        return "StateMetaData{state=" + this.state + ", status=" + this.status + ", sequence=" + this.sequence + ", timestamp=" + this.timestamp + ", sensorLocation=" + this.sensorLocation + "}";
    }

    public static enum State {
        STAMP,
        START,
        STOP,
        PAUSE,
        RESUME;

    }

    public static enum Status {
        SUCCESS,
        bdiError;

    }
}

