/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Logging;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleState;
import org.lsst.ccs.subsystem.shutter.statemachine.TopContext;

class Synchronizing
extends SimpleState<TopContext> {
    private static final Logger LOG = Logger.getLogger(Synchronizing.class.getName());

    public Synchronizing(TopContext context) {
        super(context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void entry() {
        Logging.logEntry(this);
        ((TopContext)this.getContext()).getActions().setSoftwareState(SoftwareState.SYNCHRONIZING);
        boolean contacted = ((TopContext)this.getContext()).getActions().makePartialContact();
        if (contacted) {
            ((TopContext)this.getContext()).getActions().resetPLC();
            ((TopContext)this.getContext()).getActions().startSyncTimer();
        }
    }

    @Override
    public void exit() {
        ((TopContext)this.getContext()).getActions().cancelSyncTimer();
        Logging.logExit(this);
    }

    @Override
    public void plcIsDisabled(Channel<EventReply> chan) throws InterruptedException {
        Logging.logEvent(this);
        chan.write(PromptReply.ACCEPTED);
        ((TopContext)this.getContext()).setPLCEnabled(false);
        ((TopContext)this.getContext()).makeTransition(((TopContext)this.getContext()).getInSyncState(), null);
    }

    @Override
    public void plcIsEnabled(Channel<EventReply> chan) throws InterruptedException {
        Logging.logEvent(this);
        chan.write(PromptReply.ACCEPTED);
        ((TopContext)this.getContext()).setPLCEnabled(true);
        ((TopContext)this.getContext()).makeTransition(((TopContext)this.getContext()).getInSyncState(), null);
    }

    @Override
    public void syncTimeout(Channel<EventReply> chan) throws InterruptedException {
        Logging.logEvent(this);
        chan.write(PromptReply.ACCEPTED);
        ((TopContext)this.getContext()).setPLCEnabled(false);
        ((TopContext)this.getContext()).setSyncAlertReason("Timed out waiting for the PLC to finish a reset command.");
        ((TopContext)this.getContext()).makeTransition(((TopContext)this.getContext()).getSyncErrorState(), null);
    }

    @Override
    public void contactLost(Channel<EventReply> chan, String msg) throws InterruptedException {
        Logging.logEvent(this);
        chan.write(PromptReply.ACCEPTED);
        ((TopContext)this.getContext()).setPLCEnabled(false);
        ((TopContext)this.getContext()).setSyncAlertReason(msg);
        ((TopContext)this.getContext()).makeTransition(((TopContext)this.getContext()).getSyncErrorState(), null);
    }
}

