/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.thorlabs;

import java.util.Date;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.thorlabs.ThorlabsFW;

public class TestFW {
    private final ThorlabsFW thfw = new ThorlabsFW();

    @Command(name="timestamp", description="Prints current time")
    public String timestamp() {
        Date now = new Date();
        return now.toString();
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="ident", description="Identification") String ident, @Argument(name="baudRate", description="Baud rate, 9600 or 115200") int baudRate) throws DriverException {
        this.thfw.open(ident, baudRate);
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="ident", description="Identification") String ident) throws DriverException {
        this.thfw.open(ident);
    }

    @Command(name="close", description="Closes connection to device")
    public void close() throws DriverException {
        this.thfw.close();
    }

    @Command(name="readAll", description="Read all controller settings and data")
    public String readAll() {
        String table = "Read all filter wheel settings and data\n" + this.timestamp() + "\n";
        ThorlabsFW.CmndFW[] cmndN = ThorlabsFW.CmndFW.values();
        int nN = cmndN.length;
        for (int i = 0; i < nN; ++i) {
            table = table + String.format("\n   %-22s", new Object[]{cmndN[i]});
            try {
                String respN = this.thfw.queryFW(cmndN[i]);
                table = table + respN;
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n";
        return table;
    }

    @Command(name="readFWpos", description="Read filter wheel position")
    public String readFWpos() throws DriverException {
        return this.thfw.queryFW(ThorlabsFW.CmndFW.POSITION);
    }

    @Command(name="setPosition", description="Set filter wheel positions")
    public void setPosition(@Argument(name="<int>", description="New position, 1 to maximum") int value) throws DriverException {
        this.thfw.setFW(ThorlabsFW.CmndFW.POSITION, value);
    }

    @Command(name="setFWsize", description="Set number of FW positions")
    public void setFWsize(@Argument(name=" <6|12>", description="Number of filter wheel positions") int value) throws DriverException {
        this.thfw.setFW(ThorlabsFW.CmndFW.POSITION_COUNT, value);
    }

    @Command(name="setTrigMode", description="Set usage of trigger connector")
    public void setTrigMode(@Argument(name=" <0|1>", description="trigger connector mode <input|output>") int value) throws DriverException {
        this.thfw.setFW(ThorlabsFW.CmndFW.TRIGGER_MODE, value);
    }

    @Command(name="setSpeed", description="Set filter wheel speed")
    public void setSpeed(@Argument(name=" <0|1>", description="filter wheel speed <low|high>") int value) throws DriverException {
        this.thfw.setFW(ThorlabsFW.CmndFW.SPEED_MODE, value);
    }

    @Command(name="setSensorMode", description="Set sensor mode for idle FW")
    public void setSensorMode(@Argument(name=" <0|1>", description="sensor mode <inactive|active> if FW idle") int value) throws DriverException {
        this.thfw.setFW(ThorlabsFW.CmndFW.SENSOR_MODE, value);
    }

    @Command(name="setDataRate", description="Set baud rate.  Danger: last-resort reset only!")
    public void setDataRate(@Argument(name=" <0|1>", description="baud rate <9600|115200>") int value) throws DriverException {
        this.thfw.setFW(ThorlabsFW.CmndFW.DATA_RATE, value);
    }

    @Command(name="saveSettings", description="Save settings for next power-up")
    public void saveSettings() throws DriverException {
        this.thfw.saveFW();
    }

    @Command(name="setDebug", description="set debug mode <true|false>")
    public void setDebug(@Argument(name="<true|false>", description="debug mode") boolean mode) {
        this.thfw.setDebug(mode);
    }
}

