/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class Filter {
    @LookupName
    private String name;
    @ConfigurationParameter(description="weight of this filter", range="0..100", units="kg", category="filter")
    private volatile double weight;
    @ConfigurationParameter(description="Filter identification number as coded on its frame and read with 6 hall effect sensors.", range="0..63", units="unitless", category="filter")
    private volatile int filterID;
    @ConfigurationParameter(description="Filter family: S ; D ; F ; T ; O; U; N", units="unitless", category="filter")
    private volatile FcsEnumerations.FilterFamily family;

    public Filter() {
    }

    Filter(int filterID, double weight) {
        this.filterID = filterID;
        this.weight = weight;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Filter identification number.")
    public int getFilterID() {
        return this.filterID;
    }

    public String getName() {
        return this.name;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Filter weight.")
    public double getWeight() {
        return this.weight;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Filter family.")
    public FcsEnumerations.FilterFamily getFamily() {
        return this.family;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFamily(FcsEnumerations.FilterFamily family) {
        this.family = family;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Filter: " + FcsUtils.padLeft(this.name, 4) + " | ");
        sb.append("ID: " + FcsUtils.padLeft(Integer.toString(this.filterID), 2) + " | ");
        sb.append("Weight: " + FcsUtils.padLeft(Double.toString(this.weight) + "kg", 6) + " | ");
        sb.append("Family: " + this.family.getFamilyName());
        return sb.toString();
    }
}

