/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.readout;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.ITLCCDType;
import org.lsst.ccs.utilities.readout.ReadOutParameters;
import org.lsst.ccs.utilities.readout.ReadOutRegisterMap;

public class ReadOutParametersOld
extends ReadOutParameters {
    private static final Logger LOG = Logger.getLogger(ReadOutParametersOld.class.getName());
    private static final String PARM_READ_ROWS = "ReadRows";
    private static final String PARM_READ_COLS = "ReadCols";
    private static final String PARM_PRE_ROWS = "PreRows";
    private static final String PARM_PRE_COLS = "PreCols";
    private static final String PARM_POST_ROWS = "PostRows";
    private static final String PARM_POST_COLS = "PostCols";
    private static final String PARM_READ_COLS2 = "ReadCols2";
    private static final String PARM_OVER_ROWS = "OverRows";
    private static final String PARM_OVER_COLS = "OverCols";
    public static final String[] DEFAULT_NAMES = new String[]{"ReadRows", "ReadCols", "PreRows", "PreCols", "PostRows", "PostCols", "ReadCols2", "OverRows", "OverCols"};
    private final int preRows = this.getValue("PreRows");
    private final int readRows = this.getValue("ReadRows");
    private final int postRows = this.getValue("PostRows");
    private final int overRows = this.getValue("OverRows");
    private final int preCols = this.getValue("PreCols");
    private final int readCols = this.getValue("ReadCols");
    private final int postCols = this.getValue("PostCols");
    private final int overCols = this.getValue("OverCols");
    private final int readCols2 = this.getValue("ReadCols2");

    ReadOutParametersOld(CCDType ccdType, int[] registers, ReadOutRegisterMap registerMap) {
        super(ccdType, registers, registerMap);
        this.validate();
    }

    ReadOutParametersOld(CCDType ccdType) {
        this(ccdType, ReadOutParametersOld.fabricateValues(ccdType), ReadOutParametersOld.fabricateNames());
    }

    private static ReadOutRegisterMap fabricateNames() {
        return new ReadOutRegisterMap(DEFAULT_NAMES);
    }

    private static int[] fabricateValues(CCDType type) {
        return new int[]{0, type.getCCDGeometryConstants().getSegmentParallelActiveSize(), 0, ReadOutParametersOld.getParallelOverscan(type), 0, type.getCCDGeometryConstants().getSegmentSerialPrescanSize() + type.getCCDGeometryConstants().getSegmentSerialActiveSize(), 0, 0, ReadOutParametersOld.getSerialOverscan(type)};
    }

    private static int getParallelOverscan(CCDType type) {
        if (type instanceof E2VCCDType) {
            return 46;
        }
        if (type instanceof ITLCCDType) {
            return 48;
        }
        return 0;
    }

    private static int getSerialOverscan(CCDType type) {
        if (type instanceof E2VCCDType) {
            return 22;
        }
        if (type instanceof ITLCCDType) {
            return 32;
        }
        return 0;
    }

    @Override
    public int getSerialReadPixels() {
        return this.readCols + this.readCols2 + this.overCols;
    }

    @Override
    public int getParallelReadPixels() {
        return this.readRows + this.overRows;
    }

    @Override
    final void validate() {
        int totalSerialPixels;
        boolean isValid = true;
        CCDType ccdType = this.getCCDType();
        int totalParallelPixels = ccdType.getCCDGeometryConstants().getSegmentParallelActiveSize();
        if (this.preRows + this.readRows + this.postRows != totalParallelPixels) {
            LOG.log(Level.WARNING, "Parallel parameters are invalid: preRows({0}) + readRows({1}) + postRows({2}) != segRows({3})", new Object[]{this.preRows, this.readRows, this.postRows, totalParallelPixels});
            isValid = false;
        }
        if (this.preCols + this.readCols + this.postCols + this.readCols2 != (totalSerialPixels = ccdType.getCCDGeometryConstants().getSegmentSerialActiveSize() + ccdType.getCCDGeometryConstants().getSegmentSerialPrescanSize())) {
            LOG.log(Level.WARNING, "Serial parameters are invalid: preCols({0}) + readCols({1}) + readCols2({2}) + postCols({3}) != serCols({4})", new Object[]{this.preCols, this.readCols, this.readCols2, this.postCols, totalSerialPixels});
            isValid = false;
        }
        if (!isValid) {
            LOG.warning("The geometry values in the Fits Headers will be incorrect.");
        }
    }

    @Override
    public int getTotalParallelSize() {
        return this.getCCDType().getCCDGeometryConstants().getSegmentParallelActiveSize() + this.overRows;
    }

    @Override
    public int getSerialPrescan() {
        return this.getCCDType().getCCDGeometryConstants().getSegmentSerialPrescanSize();
    }

    @Override
    public int getTotalSerialSize() {
        return this.preCols + this.readCols + this.postCols + this.readCols2 + this.overCols;
    }
}

