/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.registry;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.DVMap;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IDataPointSet;
import hep.aida.IFunction;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IManagedObject;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.ITupleColumn;
import hep.aida.ref.plotter.style.registry.IPlotterState;
import hep.aida.ref.plotter.style.registry.JELRule;
import hep.aida.ref.plotter.style.registry.PlotterState;
import java.util.Date;
import java.util.Vector;

public class JELRuleCompiledExpression {
    private String expression;
    private String parsedExpression;
    private CompiledExpression compExpression;
    private Library lib;
    private ValueProvider pro;
    private Object[] context;
    private Resolver res;
    private Vector attributes;

    public JELRuleCompiledExpression(String expression) {
        this.expression = expression;
        this.attributes = new Vector();
        this.parse();
        this.compile();
    }

    private int getAttributeIndex(String key) {
        return this.pro.getAttributeIndex(key);
    }

    public void parse() {
        this.parsedExpression = this.expression;
    }

    private void compile() {
        Class[] staticLib = new Class[1];
        Class[] dynamicLib = new Class[1];
        this.context = new Object[1];
        Class[] dotLib = new Class[]{Object.class, String.class, Class.class, Date.class};
        try {
            staticLib[0] = Class.forName("java.lang.Math");
            this.pro = new ValueProvider();
            dynamicLib[0] = this.pro.getClass();
            this.context[0] = this.pro;
            this.res = new Resolver();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can not find class for JEL!", e);
        }
        try {
            this.lib = new Library(staticLib, dynamicLib, dotLib, (DVMap)this.res, null);
            this.lib.markStateDependent("random", null);
        }
        catch (CompilationException ec1) {
            throw new RuntimeException("Can not compile JEL Library!", ec1);
        }
        try {
            this.compExpression = Evaluator.compile((String)this.parsedExpression, (Library)this.lib, Boolean.TYPE);
        }
        catch (CompilationException ec2) {
            throw new RuntimeException("Can not compile JEL Expression: " + this.expression, ec2);
        }
    }

    public boolean evaluate(IPlotterState state) {
        boolean ruleApplies = false;
        this.pro.setState(state);
        try {
            ruleApplies = this.compExpression.evaluate_boolean(this.context);
        }
        catch (Throwable t) {
            throw new RuntimeException("Runtime JEL Evaluation Problems!", t);
        }
        return ruleApplies;
    }

    public static void main(String[] args) throws Exception {
        String expr = "overlayCount == 3";
        JELRuleCompiledExpression ce = new JELRuleCompiledExpression(expr);
        PlotterState state = new PlotterState();
        state.setObjectPath("mc");
        state.setAttribute("printing", "true");
        state.setAttribute("experiment", "BaBar");
        state.setOverlayIndex(3);
        state.setObject(new JELRule());
        boolean ok = ce.evaluate(state);
        System.out.println("ok=" + ok);
    }

    public class ValueProvider {
        private IPlotterState state;

        public ValueProvider() {
            this(null);
        }

        public ValueProvider(IPlotterState state) {
            this.state = state;
        }

        int getAttributeIndex(String key) {
            return this.state == null ? 0 : ((PlotterState)this.state).getAttributeIndex(key);
        }

        public void setState(IPlotterState state) {
            this.state = state;
        }

        public String getStringProperty(int index) {
            String value = null;
            if (index == -10) {
                value = null;
            } else if (index == -2) {
                value = this.objectAIDAType();
            } else if (index == -1) {
                value = this.state.getObjectPath();
            } else if (index >= 0) {
                value = this.state.getAttribute((String)JELRuleCompiledExpression.this.attributes.get(index));
            }
            return value;
        }

        public Object getObjectProperty(int index) {
            Object value = null;
            if (index == 0) {
                value = null;
            } else if (index == 1) {
                value = this.state.getObject();
            }
            return value;
        }

        public int getIntegerProperty(int index) {
            int value = -1;
            if (index == 0) {
                return this.state.getOverlayIndex();
            }
            if (index == 1) {
                value = this.state.getOverlayTotal();
            } else if (index == 2) {
                value = this.state.getRegionIndex();
            } else if (index == 3) {
                value = this.state.getRegionTotal();
            }
            return value;
        }

        public String attribute(String key) {
            String value = this.state.getAttribute(key);
            if (value == null) {
                value = "";
            }
            return value;
        }

        public String objectAIDAType() {
            Object obj = this.state.getObject();
            String value = null;
            value = obj == null ? "null" : (obj instanceof IDataPointSet ? "IDataPointSet" : (obj instanceof IHistogram1D ? "IHistogram1D" : (obj instanceof IHistogram2D ? "IHistogram2D" : (obj instanceof IHistogram3D ? "IHistogram3D" : (obj instanceof ICloud1D ? "ICloud1D" : (obj instanceof ICloud2D ? "ICloud2D" : (obj instanceof ICloud3D ? "ICloud3D" : (obj instanceof IProfile1D ? "IProfile1D" : (obj instanceof IProfile2D ? "IProfile2D" : (obj instanceof IFunction ? "IFunction" : (obj instanceof ITupleColumn ? "ITupleColumn" : (obj instanceof IManagedObject ? ((IManagedObject)obj).type() : obj.getClass().getName()))))))))))));
            return value;
        }

        public boolean isObjectInstanceOf(String className) {
            boolean ok = false;
            try {
                Class<?> clazz = Class.forName(className);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ok;
        }
    }

    public class Resolver
    extends DVMap {
        public String getTypeName(String name) {
            if (name.trim().equalsIgnoreCase("Path")) {
                return "String";
            }
            if (name.trim().equalsIgnoreCase("Object")) {
                return "Object";
            }
            if (name.trim().equalsIgnoreCase("ObjectAIDAType")) {
                return "String";
            }
            if (name.trim().equalsIgnoreCase("Null")) {
                return "Object";
            }
            if (name.trim().equalsIgnoreCase("OverlayIndex")) {
                return "Integer";
            }
            if (name.trim().equalsIgnoreCase("OverlayTotal")) {
                return "Integer";
            }
            if (name.trim().equalsIgnoreCase("RegionIndex")) {
                return "Integer";
            }
            if (name.trim().equalsIgnoreCase("RegionTotal")) {
                return "Integer";
            }
            return null;
        }

        public Object translate(String name) {
            if (name.trim().equalsIgnoreCase("Path")) {
                return new Integer(-1);
            }
            if (name.trim().equalsIgnoreCase("Object")) {
                return new Integer(1);
            }
            if (name.trim().equalsIgnoreCase("ObjectAIDAType")) {
                return new Integer(-2);
            }
            if (name.trim().equalsIgnoreCase("Null")) {
                return new Integer(-10);
            }
            if (name.trim().equalsIgnoreCase("OverlayIndex")) {
                return new Integer(0);
            }
            if (name.trim().equalsIgnoreCase("OverlayTotal")) {
                return new Integer(1);
            }
            if (name.trim().equalsIgnoreCase("RegionIndex")) {
                return new Integer(2);
            }
            if (name.trim().equalsIgnoreCase("RegionTotal")) {
                return new Integer(3);
            }
            return new Integer(100);
        }
    }
}

