/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ccob.thin;

import java.io.Serializable;
import java.time.Duration;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystem.ccob.thin.Controller;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeOutputLine;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SetupCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.ShellCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;

public class Commands
extends Subsystem
implements MotorCommandListener,
ShellCommandListener {
    private static final Logger LOG = Logger.getLogger(Commands.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Controller controller;

    public Commands() {
        super("commands", AgentInfo.AgentType.WORKER);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="(text) Returns the last reply from the TB server.")
    public String getLastReply() {
        return this.controller.getLastReply();
    }

    @Command(level=0, description="(code) Relative motion of one axis.")
    public void moveAxisRelative(MoveAxisRelative cmd) {
        this.controller.moveAxisRelative(cmd);
    }

    @Command(level=0, description="(text) Relative motion: moveBy axisName positionChange speed")
    public void moveBy(String axisName, double positionChange, double speed) {
        this.moveAxisRelative(new MoveAxisRelative(axisName, positionChange, Duration.ofMillis(Math.round(1000.0 * Math.abs(positionChange) / speed))));
    }

    @Command(level=0, description="(code) Absolute motion of one axis.")
    public void moveAxisAbsolute(MoveAxisAbsolute cmd) {
        this.controller.moveAxisAbsolute(cmd);
    }

    @Command(level=0, description="(text) Absolute motion: moveTo axisName newPosition speed")
    public void moveTo(String axisName, double newPosition, double speed) {
        this.moveAxisAbsolute(new MoveAxisAbsolute(axisName, newPosition, speed));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="(code) Send ASAP on the status bus an AxisStatus message for the given axis.")
    public void sendAxisStatus(SendAxisStatus cmd) {
        this.controller.sendAxisStatus(cmd);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="(code) Send ASAP on the status bus a PlatformConfig message describing the hardware.")
    public void sendConfiguration(SendConfiguration cmd) {
        this.controller.sendConfiguration(cmd);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="(code) Send ASAP on the status bus a ControllerStatus message.")
    public void sendControllerStatus(SendControllerStatus cmd) {
        this.controller.sendControllerStatus(cmd);
    }

    @Command(level=0, description="(code) Stop any motion in progress.")
    public void stopAllMotion(StopAllMotion cmd) {
        this.controller.stopAllMotion(cmd);
    }

    @Command(level=0, description="(text) Stop any motion in progress. No arguments.")
    public void stopAll() {
        this.stopAllMotion(new StopAllMotion());
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="(text) Gets a text report on the status of a hardware controller.")
    public String status(@Argument(description="The controller name. One of XY, UB, P, H, K or SUMMARY. Case is ignored.") String controllerName) {
        return this.controller.status(controllerName);
    }

    @Command(level=0, autoAck=false, description="Not supported for thin-beam CCOB.")
    public void changeAxisEnable(ChangeAxisEnable cmd) {
        this.sendNack((Serializable)((Object)"Not supported for thin-beam CCOB."));
    }

    @Command(level=0, autoAck=false, description="Not supported for thin-beam CCOB.")
    public void changeOutputLine(ChangeOutputLine cmd) {
        this.sendNack((Serializable)((Object)"Not supported for thin-beam CCOB."));
    }

    @Command(level=0, autoAck=false, description="Not supported for thin-beam CCOB.")
    public void clearAllFaults(ClearAllFaults cmd) {
        this.sendNack((Serializable)((Object)"Not supported for thin-beam CCOB."));
    }

    @Command(level=0, autoAck=false, description="Not supported for thin-beam CCOB.")
    public void clearAxisFaults(ClearAxisFaults cmd) {
        this.sendNack((Serializable)((Object)"Not supported for thin-beam CCOB."));
    }

    @Command(level=0, autoAck=false, description="Not supported for thin-beam CCOB.")
    public void clearCapture(ClearCapture cmd) {
        this.sendNack((Serializable)((Object)"Not supported for thin-beam CCOB."));
    }

    @Command(level=0, autoAck=false, description="Not supported for thin-beam CCOB.")
    public void enableAllAxes(EnableAllAxes cmd) {
        this.sendNack((Serializable)((Object)"Not supported for thin-beam CCOB."));
    }

    @Command(level=0, autoAck=false, description="Not supported for thin-beam CCOB.")
    public void disableAllAxes(DisableAllAxes cmd) {
        this.sendNack((Serializable)((Object)"Not supported for thin-beam CCOB."));
    }

    @Command(level=0, autoAck=false, description="Not supported for thin-beam CCOB.")
    public void homeAxis(HomeAxis cmd) {
        this.sendNack((Serializable)((Object)"Not supported for thin-beam CCOB."));
    }

    @Command(level=0, autoAck=false, description="Not supported for thin-beam CCOB.")
    public void setupCapture(SetupCapture cmd) {
        this.sendNack((Serializable)((Object)"Not supported for thin-beam CCOB."));
    }

    @Command(level=0, autoAck=false, description="Not supported for thin-beam CCOB.")
    public void clearFaults() {
        this.sendNack((Serializable)((Object)"Not supported for thin-beam CCOB."));
    }

    @Command(level=0, autoAck=false, description="Not supported for thin-beam CCOB.")
    public void enable(String axisName) {
        this.sendNack((Serializable)((Object)"Not supported for thin-beam CCOB."));
    }

    @Command(level=0, autoAck=false, description="Not supported for thin-beam CCOB.")
    public void disable(String axisName) {
        this.sendNack((Serializable)((Object)"Not supported for thin-beam CCOB."));
    }

    @Command(level=0, autoAck=false, description="Not supported for thin-beam CCOB.")
    public void home(String axisName) {
        this.sendNack((Serializable)((Object)"Not supported for thin-beam CCOB."));
    }

    @Command(level=0, description="(text) Turns on the photodiode.")
    public void diodeOn() {
        this.controller.switchDiode("ON");
    }

    @Command(level=0, description="(text) Turns off the photodiode.")
    public void diodeOff() {
        this.controller.switchDiode("OFF");
    }

    @Command(level=0, description="(text) Gets the current photodiode status.")
    public String diodeStatus() {
        return this.status("P");
    }

    @Command(level=0, description="(text) Gets the current pico-ammeter status.")
    public String picoStatus() {
        return this.status("K");
    }

    @Command(level=0, description="(text) Returns the pico-ammeter current in A.")
    public double picoReadCurrent() {
        return this.controller.picoReadCurrent();
    }

    @Command(level=0, description="(text) Sets the pico-ammeter integration time.")
    public void picoSetTime(@Argument(description="The integration time in ms.") double millis) {
        this.controller.picoSetTime(millis);
    }

    @Command(level=0, description="(text) Sets the expected current range for the pico-ammeter.")
    public void picoSetRange(@Argument(description="The range index: -1 (auto-range) or 0 to 7 inclusive.") int range) {
        this.controller.picoSetRange(range);
    }

    @Command(level=0, description="(text) Gets the range setting in amps for the pico-ammeter.")
    public double picoGetRange() {
        return this.controller.picoGetRange();
    }

    @Command(level=0, description="(text) Sets the light source wavelength.")
    public void hyperSetWavelength(@Argument(description="Either a wavelength in nanometers or a color name like UVA or FIR. Case is ignored.") String wavelength) {
        this.controller.hyperSetWavelength(wavelength);
    }

    @Command(level=0, description="(text) Opens the high-speed shutter and leaves it open.")
    public void hyperOpenFastShutter() {
        this.controller.hyperSwitchFastShutter("ON");
    }

    @Command(level=0, description="(text) Closes the high-speed shutter and leaves it closed.")
    public void hyperCloseFastShutter() {
        this.controller.hyperSwitchFastShutter("OFF");
    }

    @Command(level=0, description="(text) Opens the high-speed shutter, starts a timer then returns. The shutter will close when the timer expires but this command will not wait for that to happen.")
    public void hyperStartFastExposure(@Argument(description="The number of milliseconds to keep the shutter open.") int millis) {
        this.controller.hyperStartFastExposure(millis);
    }

    @Command(level=0, description="(text) Opens the slow (main) shutter and leaves it open.")
    public void hyperOpenMainShutter() {
        this.controller.hyperSwitchMainShutter("ON");
    }

    @Command(level=0, description="(text) Closes the slow (main) shutter and leaves it closed.")
    public void hyperCloseMainShutter() {
        this.controller.hyperSwitchMainShutter("OFF");
    }

    @Command(level=0, description="(text) Turns on the light source and leaves it on.")
    public void hyperLightLamp() {
        this.controller.hyperSwitchLamp("ON");
    }

    @Command(level=0, description="(text) Turns off the light source and leaves it off.")
    public void hyperKillLamp() {
        this.controller.hyperSwitchLamp("OFF");
    }

    @Command(level=0, description="(text) Removes the filter and moves to the zero-order position of one of the gratings.")
    public void hyperRemoveFilter(@Argument(description="The name of the grating, A or B. case is ignored.") String gratingName) {
        this.controller.hyperZOP(gratingName);
    }

    @Command(level=0, description="(text) Returns a status report for the hyperchromator.")
    public String hyperStatus() {
        return this.status("H");
    }

    @Command(level=0, description="(text) Starts the pico-ammeter reading after opening the high-speed shutter. Returns the reading in amps. Preferred over readThenIlluminate().")
    public double illuminateThenRead(@Argument(description="The pico-ammeter integration time, and the high-speed shutter time to be open, in ms.") int millis) {
        return this.controller.illuminateThenRead(millis);
    }

    @Command(level=0, description="(text) Starts the pico-ammeter reading before opening the high-speed shutter. The pico-ammeter range and integration time must have been previously set. Auto-ranging not allowed. Returns the reading in amps. May have sync problems.")
    public double readThenIlluminate(@Argument(description="The time to keep the high-speed shutter open, in ms.") int millis) {
        return this.controller.readThenIlluminate(millis);
    }

    @Command(level=0, description="(text) Gets the diode repsonse attenuation for the current wavelength setting of the hyperchromator (200-11nm only).")
    public double getDiodeAttenuation() {
        return this.controller.getDiodeAttenuation();
    }

    @Command(level=0, description="(text) Displays information about the current target.")
    public String getTarget() {
        return this.controller.getTarget();
    }

    @Command(level=0, description="(text) Sets the target to the given sensor plane XY coordinates.")
    public void setTargetTo(@Argument(description="The desired sensor plane X coordinate, in mm.") double x, @Argument(description="The desired sensor plane Y coordinate, in mm.") double y) {
        this.controller.setTargetTo(x, y);
    }

    @Command(level=0, description="(text) Sets the target to the current sensor plane coordinates.")
    public void setTargetHere() {
        this.controller.setTargetHere();
    }

    @Command(level=0, description="(text) Move in XY to aim at current target after a change in UB.")
    public void aimAgainXY() {
        this.controller.aimAgainXY();
    }

    @Command(level=0, description="(text) Move in UB to aim at current target after a change in XY.")
    public void aimAgainUB() {
        this.controller.aimAgainUB();
    }
}

