/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.gpio.GPIODriver;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.teststand.data.UnoGPIOLines;
import org.lsst.ccs.subsystem.teststand.states.Fe55ShutterState;
import org.lsst.ccs.utilities.logging.Logger;

public class Fe55Shutter
implements HasLifecycle {
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @ConfigurationParameter(isFinal=true, description="GPIO output line")
    private volatile UnoGPIOLines.Output gpioLine;
    private GPIODriver gpio;
    private GPIODriver.GPIOChannel channel;
    private Logger log;
    private boolean initialized = false;

    public void init() {
        this.stateService.registerState(Fe55ShutterState.class, "Fe55 Shutter State", (Object)this);
        this.log = this.subsys.getLogger();
        if (this.gpioLine == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"gpioLine", (String)"not set");
        }
        try {
            this.gpio = new GPIODriver();
            this.channel = this.gpio.getChannel(this.gpioLine.getLine());
            if (this.channel.getDirection() != GPIODriver.GPIOChannel.Direction.OUT) {
                MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"gpioLine", (String)"not a writable channel");
            }
            this.channel.lock();
            this.initialized = true;
            this.channel.write(false);
            this.publishState(false);
        }
        catch (DriverException ex) {
            this.log.error((Object)(this.name + "Failure to initialize GPIO channel: " + ex.getMessage()));
        }
    }

    public void setShutter(boolean state) throws DriverException {
        if (!this.initialized) {
            throw new RuntimeException(this.name + ": GPIO line not initialized");
        }
        this.channel.write(state);
        this.publishState(state);
    }

    private void publishState(boolean state) {
        Fe55ShutterState enumState = Fe55ShutterState.getEnum((boolean)state);
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{enumState});
        this.log.info((Object)(this.name + ":  digital control line set to state " + enumState.toString()));
    }

    @Command(type=Command.CommandType.ACTION, name="setShutterPosition", description="Open or close Fe55 shutters on one controller")
    public void setShutterPosition(@Argument(name="<boolean>", description="<true|false> for <open|close>") boolean state) throws DriverException {
        this.setShutter(state);
    }
}

