/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.apcpdu.AP9630UPS;
import org.lsst.ccs.drivers.ascii.Session;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.utilities.logging.Logger;

public class AP9630UPSDevice
extends Device {
    public static final int CHAN_OUT_VOLTAGE = 0;
    public static final int CHAN_OUT_CURRENT = 1;
    public static final int CHAN_OUT_POWER = 2;
    public static final int CHAN_BATT_TEMP = 3;
    public static final int CHAN_BATT_VOLTAGE = 4;
    public static final int CHAN_BATT_CHARGE = 5;
    public static final int CHAN_STATUS = 6;
    public static final int CHAN_REM_TIME = 7;
    public static final int NUM_CHANNELS = 8;
    @ConfigurationParameter(isFinal=true, description="telnet node")
    volatile String node;
    String user = "apc";
    String passwd = "apc";
    final Logger sLog = Logger.getLogger((String)((Object)((Object)this)).getClass().getPackage().getName());
    private final AP9630UPS ups = new AP9630UPS();
    TSState.pwrstates kstate = TSState.pwrstates.NOTCONFIGURED;

    protected void initDevice() {
        if (this.node == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"node", (String)"is not specified");
        }
        this.fullName = "AP9630 UPS (" + this.node + ")";
    }

    protected void initialize() {
        try {
            this.ups.open(Session.ConnType.TELNET, this.node, this.user, this.passwd);
            this.initSensors();
            this.kstate = TSState.pwrstates.OK;
            this.sLog.info((Object)("Connected to " + this.fullName));
            this.setOnline(true);
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.sLog.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.ups.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
        this.kstate = TSState.pwrstates.NOTCONFIGURED;
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 8) {
            MonitorLogUtils.reportError((Logger)this.sLog, (String)name, (String)"hardware channel", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
    }

    protected double readChannel(int hwChan, int type) {
        double value = 0.0;
        try {
            switch (hwChan) {
                case 0: {
                    return this.ups.getOutputVoltage();
                }
                case 1: {
                    return this.ups.getOutputCurrent();
                }
                case 2: {
                    return this.ups.getOutputPower();
                }
                case 4: {
                    return this.ups.getBatteryVoltage();
                }
                case 5: {
                    return this.ups.getBatteryCharge();
                }
                case 3: {
                    return this.ups.getTemperature();
                }
                case 6: {
                    return this.ups.getStatus();
                }
                case 7: {
                    return this.ups.getRunTime();
                }
            }
        }
        catch (DriverException e) {
            this.sLog.error((Object)("Error reading UPS channel: " + (Object)((Object)e)));
            this.setOnline(false);
        }
        return value;
    }

    @Command(name="getStatus", description="Get the UPS status")
    public int getStatus() throws DriverException {
        try {
            return this.ups.getStatus();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error getting UPS status: " + (Object)((Object)e)));
            throw e;
        }
    }

    @Command(name="getRemTime", description="Get the UPS remaining time")
    public int getRemTime() throws DriverException {
        try {
            return this.ups.getRunTime();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error getting UPS remaining time: " + (Object)((Object)e)));
            throw e;
        }
    }

    @Command(name="disable", description="Disable the connection to the UPS")
    public void disable() {
        super.disable();
        this.setOnline(false);
    }

    @Command(name="enable", description="Enable the connection to the UPS")
    public void enable() {
        super.enable();
    }
}

