/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import org.opensplice.dds.dcps.ObjectImpl;

public class ReportStack {
    private ReportStack() {
    }

    public static void report(int code, String message) {
        int line = 0;
        String file = null;
        String method = null;
        StackTraceElement trace = Thread.currentThread().getStackTrace()[2];
        file = trace.getFileName();
        if (file == null) {
            file = trace.getClassName() + ".java";
        }
        line = trace.getLineNumber();
        method = trace.getClassName() + "." + trace.getMethodName();
        ReportStack.jniReport(file, line, method, code, message);
    }

    public static void deprecated(String message) {
        int line = 0;
        String file = null;
        String method = null;
        StackTraceElement trace = Thread.currentThread().getStackTrace()[2];
        file = trace.getFileName();
        if (file == null) {
            file = trace.getClassName() + ".java";
        }
        line = trace.getLineNumber();
        method = trace.getClassName() + "." + trace.getMethodName();
        ReportStack.jniReportDeprecated(file, line, method, message);
    }

    public static void flush(boolean flush) {
        ReportStack.flushReport(null, flush);
    }

    public static void flush(ObjectImpl obj, boolean flush) {
        ReportStack.flushReport(obj, flush);
    }

    private static void flushReport(ObjectImpl obj, boolean flush) {
        int line = 0;
        String file = null;
        String method = null;
        if (ReportStack.jniReportFlushRequired(flush) != 0) {
            StackTraceElement trace = Thread.currentThread().getStackTrace()[3];
            int domainId = obj != null ? obj.getDomainId() : -1;
            file = trace.getFileName();
            if (file == null) {
                file = trace.getClassName() + ".java";
            }
            method = trace.getClassName() + "." + trace.getMethodName();
            line = trace.getLineNumber();
            ReportStack.jniFlush(file, line, method, flush, domainId);
        }
    }

    public static native void start();

    public static native void jniReport(String var0, int var1, String var2, int var3, String var4);

    public static native void jniReportDeprecated(String var0, int var1, String var2, String var3);

    public static native int jniReportFlushRequired(boolean var0);

    public static native void jniFlush(String var0, int var1, String var2, boolean var3, int var4);
}

