/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.math.BigDecimal;
import java.security.SecureRandom;
import org.lsst.ccs.subsystems.fcs.drivers.CanCBXAI814;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSensor14bits;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenInterface;

public class SimuCanOpenADC
extends CanCBXAI814 {
    int value1 = 0;
    int value2 = Short.MAX_VALUE;
    private final SecureRandom randomGenerator = new SecureRandom();

    @Override
    public void initializeAndCheckHardware() {
        super.initializeAndCheckHardware();
        for (int i = 0; i < 7; ++i) {
            this.updateFakePDOData(i, 0);
        }
    }

    protected void writeTransmissionTypeToDevice() {
        FCSLOG.info(this.name + " is initialized.");
    }

    public void updateFakePDOData(int numOfAnalogInput, int value) {
        long newPDOValue;
        int cobid;
        if (numOfAnalogInput >= 8) {
            throw new IllegalArgumentException(numOfAnalogInput + " bad value; should be < 8");
        }
        this.inputs[numOfAnalogInput] = value;
        if (numOfAnalogInput < 5) {
            cobid = this.cobid1;
            newPDOValue = (long)(this.inputs[0] + (this.inputs[1] << 16)) + ((long)this.inputs[2] << 32) + ((long)this.inputs[3] << 48);
        } else {
            cobid = this.cobid2;
            newPDOValue = (long)(this.inputs[4] + (this.inputs[5] << 16)) + ((long)this.inputs[6] << 32) + ((long)this.inputs[7] << 48);
        }
        ((SimuCanOpenInterface)this.tcpProxy.getCanInterface()).simulatePDOData(cobid, newPDOValue);
    }

    public void simulateNewValue(int numOfAnalogInput, int minValue, int maxValue) {
        this.checkValues(minValue, maxValue);
        int value = this.computeNewValue(minValue, maxValue);
        this.updateFakePDOData(numOfAnalogInput, value);
    }

    void checkValues(int aValue1, int aValue2) {
        if (aValue2 > Short.MAX_VALUE) {
            throw new IllegalArgumentException(this.name + "aValue2=" + aValue2 + " Can't be >" + Short.MAX_VALUE);
        }
        if (aValue1 < 0) {
            throw new IllegalArgumentException(this.name + " aValue1=" + aValue1 + " Can't be <" + 0);
        }
        if (aValue2 < aValue1) {
            throw new IllegalArgumentException(this.name + " aValue1=" + aValue1 + " aValue2=" + aValue2 + "we must have: aValue1<aValue2");
        }
    }

    int computeNewValue(int value1, int value2) {
        if (value2 > 0) {
            int n = this.randomGenerator.nextInt(value2);
            if (n > value1) {
                return n;
            }
            BigDecimal bd = new BigDecimal(value1 + n * (value2 - value1) / value2);
            return bd.intValue();
        }
        String msg = this.getName() + ": ERROR in readNewValue: value2 should be positive";
        throw new IllegalArgumentException(msg);
    }

    public void simulateSensorValue(CanOpenSensor14bits sensor, int minValue, int maxValue) {
        this.simulateNewValue(sensor.getNumOfAnalogInput(), minValue, maxValue);
        sensor.updateValue();
    }
}

