/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import jline.console.ConsoleReader;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class TalkAscii {
    private static final Map<Terminator, Ascii.Terminator> termMap = new HashMap<Terminator, Ascii.Terminator>();
    private static final PrintStream out;
    private final Thread readW = new Thread(new Reader());
    private final Ascii dev = new Ascii();
    private Ascii.Terminator respTerm;
    private int nRead = 0;
    private int nByte = 0;
    private int nTimeout = 0;
    private boolean open;
    private boolean showHex;

    public static void main(String[] args) {
        Options optns = new Options();
        CmdLineParser parser = new CmdLineParser((Object)optns);
        try {
            parser.parseArgument(args);
            if (optns.showHelp) {
                TalkAscii.showHelp(parser);
            } else {
                new TalkAscii().run(optns);
            }
        }
        catch (CmdLineException e) {
            if (!optns.showHelp) {
                out.println(e.getMessage());
            }
            TalkAscii.showHelp(parser);
        }
        catch (Exception e) {
            out.println(e);
        }
        System.exit(0);
    }

    private void run(Options optns) throws Exception {
        String line;
        this.respTerm = termMap.get((Object)optns.term);
        if (this.respTerm != null) {
            this.dev.setResponseTerm(this.respTerm);
        }
        String termStr = this.respTerm != null ? (optns.term == Terminator.INT ? "\r" : this.respTerm.getValue()) : "";
        this.dev.setTimeout(optns.timeout);
        this.dev.open(optns.type, optns.ident, optns.parm, Ascii.makeDataCharacteristics(optns.dataBits, optns.stopBits, optns.parity, optns.flowCtrl));
        this.open = true;
        this.showHex = optns.showHex;
        this.readW.setDaemon(true);
        this.readW.start();
        ConsoleReader readC = new ConsoleReader();
        out.println("Connected. Type CTRL-D to exit" + (optns.showCounts ? ", CR for read stats." : "."));
        while ((line = readC.readLine("")) != null) {
            if (line.isEmpty() && optns.showCounts) {
                out.format("#reads: %s; #bytes: %s; #timeouts: %s %n", this.nRead, this.nByte, this.nTimeout);
                continue;
            }
            this.dev.writeBytes((line + termStr).getBytes());
        }
        this.open = false;
        this.dev.close();
    }

    private static void showHelp(CmdLineParser parser) {
        out.println("Usage: TalkAscii [options...] <ident> <parm>");
        out.println("Parameters & options:");
        parser.printUsage((OutputStream)out);
    }

    static {
        termMap.put(Terminator.INT, Ascii.Terminator.CRLF);
        termMap.put(Terminator.CR, Ascii.Terminator.CR);
        termMap.put(Terminator.LF, Ascii.Terminator.LF);
        termMap.put(Terminator.CRLF, Ascii.Terminator.CRLF);
        out = System.out;
    }

    private class Reader
    implements Runnable {
        private Reader() {
        }

        @Override
        public void run() {
            while (TalkAscii.this.open) {
                byte[] buff = new byte[1024];
                try {
                    if (TalkAscii.this.respTerm != null) {
                        String reply = TalkAscii.this.dev.read();
                        out.println(reply);
                        TalkAscii.this.nByte = TalkAscii.this.nByte + reply.length();
                    } else {
                        int leng = TalkAscii.this.dev.readBytes(buff, 0);
                        if (TalkAscii.this.showHex) {
                            for (int j = 0; j < leng; ++j) {
                                out.format("%02x ", buff[j]);
                            }
                        } else {
                            out.print(new String(buff, 0, leng));
                        }
                        TalkAscii.this.nByte = TalkAscii.this.nByte + leng;
                    }
                    TalkAscii.this.nRead++;
                }
                catch (DriverTimeoutException e) {
                    TalkAscii.this.nTimeout++;
                }
                catch (DriverException e) {
                    if (!TalkAscii.this.open) continue;
                    out.println((Object)e);
                    System.exit(0);
                }
            }
        }
    }

    private static class Options {
        @Option(name="-c", metaVar="<connType>", usage="Connection type: net (default) or serial")
        private DriverConstants.ConnType type = DriverConstants.ConnType.NET;
        @Option(name="-p", metaVar="<parity>", usage="Parity: none (default), odd, even, mark or space")
        private Ascii.Parity parity = Ascii.Parity.NONE;
        @Option(name="-d", metaVar="<dbits>", usage="No. data bits: eight (default) or seven")
        private Ascii.DataBits dataBits = Ascii.DataBits.EIGHT;
        @Option(name="-s", metaVar="<sbits>", usage="No. stop bits: one (default) or two")
        private Ascii.StopBits stopBits = Ascii.StopBits.ONE;
        @Option(name="-f", metaVar="<flow>", usage="Flow control: none (default), rts, dtr or xon")
        private Ascii.FlowCtrl flowCtrl = Ascii.FlowCtrl.NONE;
        @Option(name="-r", metaVar="<timeout>", usage="Read timeout (sec) (default = 0.1)")
        private double timeout = 0.1;
        @Option(name="-t", metaVar="<term>", usage="Cmnd/resp termination: int (default), cr, lf, crlf or none")
        private Terminator term = Terminator.INT;
        @Option(name="-n", usage="Displays read counters when command is empty")
        private boolean showCounts;
        @Option(name="-x", usage="Displays read data in hexadecimal")
        private boolean showHex;
        @Option(name="-help", usage="Displays this help")
        private boolean showHelp;
        @Argument(index=0, required=true, metaVar="<ident>", usage="Device identifier (node, serial no. or device name)")
        private String ident;
        @Argument(index=1, required=true, metaVar="<parm>", usage="Device parameter (port number or baud rate)")
        private int parm;

        private Options() {
        }
    }

    private static enum Terminator {
        NONE,
        INT,
        CR,
        LF,
        CRLF;

    }
}

