/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.refrig.SimCompPlutoDevice;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;

public class SimCompPlutoPersist
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private PersistencyService persistencyService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, SimCompPlutoDevice> devices = new HashMap<String, SimCompPlutoDevice>();
    @Persist
    private volatile Map<String, LatchState[]> latchesMap = new HashMap<String, LatchState[]>();
    @Persist
    private volatile Map<String, ConditionState[]> conditionsMap = new HashMap<String, ConditionState[]>();
    @Persist
    private volatile Map<String, boolean[]> switchesMap = new HashMap<String, boolean[]>();

    public void build() {
        this.persistencyService.setAutomatic(true, true);
        this.persistencyService.setPersistencyFileName(this.subsys.getName() + "_" + this.name + ".properties");
    }

    public void postStart() {
        for (String devcName : this.devices.keySet()) {
            String compName = devcName.split("/")[0];
            SimCompPlutoDevice device = this.devices.get(devcName);
            LatchState[] latches = this.latchesMap.get(compName);
            if (latches != null) {
                device.setLatches(latches);
            }
            this.latchesMap.put(compName, device.getLatches());
            ConditionState[] conditions = this.conditionsMap.get(compName);
            if (conditions != null) {
                device.setConditions(conditions);
            }
            this.conditionsMap.put(compName, device.getConditions());
            boolean[] switches = this.switchesMap.get(compName);
            if (switches != null) {
                device.setSwitches(switches);
            }
            this.switchesMap.put(compName, device.getSwitches());
        }
    }
}

