/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jgroups.tests.Probe;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.messaging.jgroups.JGroupsBusMessagingLayer;

public class ClusterSplitUtils {
    public static Set<String>[] splitCluster(int nSplits, Set<String> allAgents) {
        HashSet[] splits = new HashSet[nSplits];
        for (int i = 0; i < nSplits; ++i) {
            splits[i] = new HashSet();
        }
        Iterator<String> iter = allAgents.iterator();
        int count = 0;
        while (iter.hasNext()) {
            splits[count % nSplits].add(iter.next());
            ++count;
        }
        for (int i = 0; i < nSplits; ++i) {
            String newView = "";
            String splitMembers = "";
            for (String member : splits[i]) {
                if (!splitMembers.isEmpty()) {
                    splitMembers = splitMembers + "/";
                }
                splitMembers = splitMembers + JGroupsBusMessagingLayer.getBusNameForAgent(member, Bus.STATUS);
            }
            for (String member : splits[i]) {
                if (!newView.isEmpty()) {
                    newView = newView + ";";
                }
                newView = newView + JGroupsBusMessagingLayer.getBusNameForAgent(member, Bus.STATUS) + "=" + splitMembers;
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("op=INJECT_VIEW.injectView[\"" + newView + "\"]");
            System.out.println("Injecting view with Probe: " + args);
            try {
                Probe.main((String[])args.toArray(new String[0]));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return splits;
    }
}

