/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.IAnnotation;
import hep.aida.IProfile1D;
import jas.hist.ExtendedStatistics;
import java.util.ArrayList;

class AIDAProfileStatistics1D
implements ExtendedStatistics {
    private IProfile1D profile;
    private final String[] statNames = new String[]{"Entries", "Mean", "Rms"};
    private final String nanExtStat = "NaN";
    private final String sumOfWeightsStat = "SumOfWeights";
    private final String outOfRangeStat = "OutOfRange";
    private final String overflowStat = "Overflow";
    private final String underflowStat = "Underflow";

    AIDAProfileStatistics1D(IProfile1D profile) {
        this.profile = profile;
    }

    public String[] getStatisticNames() {
        ArrayList<String> stat = new ArrayList<String>();
        for (int i = 0; i < this.statNames.length; ++i) {
            stat.add(this.statNames[i]);
        }
        if ((Integer)this.getExtendedStatistic("OutOfRange") != 0) {
            stat.add("OutOfRange");
        }
        if ((Integer)this.getExtendedStatistic("NaN") != 0) {
            stat.add("NaN");
        }
        if ((double)((Integer)this.getExtendedStatistic("Entries")).intValue() != (Double)this.getExtendedStatistic("SumOfWeights")) {
            stat.add("SumOfWeights");
        }
        this.addAnnotationStatistics(stat);
        String[] statArray = new String[stat.size()];
        for (int i = 0; i < stat.size(); ++i) {
            statArray[i] = (String)stat.get(i);
        }
        return statArray;
    }

    public double getStatistic(String name) {
        if (name.equals("Mean")) {
            return this.profile.mean();
        }
        if (name.equals("Rms")) {
            return this.profile.rms();
        }
        return 0.0;
    }

    public Object getExtendedStatistic(String name) {
        if (name.equals("Entries")) {
            return new Integer(this.profile.entries());
        }
        if (name.equals("OutOfRange")) {
            return new Integer(this.profile.extraEntries());
        }
        if (name.equals("Overflow")) {
            return new Integer(this.profile.binEntries(-1));
        }
        if (name.equals("Underflow")) {
            return new Integer(this.profile.binEntries(-2));
        }
        if (name.equals("NaN")) {
            return new Integer(this.profile.nanEntries());
        }
        if (name.equals("SumOfWeights")) {
            return new Double(this.profile.sumBinHeights());
        }
        IAnnotation an = this.profile.annotation();
        if (an == null) {
            return null;
        }
        String v = null;
        try {
            if (an.hasKey("stat." + name)) {
                v = an.value("stat." + name);
            } else if (an.hasKey("stat:" + name)) {
                v = an.value("stat:" + name);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return v;
    }

    private void addAnnotationStatistics(ArrayList stat) {
        IAnnotation an = this.profile.annotation();
        if (an == null) {
            return;
        }
        boolean isOutOfRangeSet = false;
        int n = an.size();
        for (int i = 0; i < n; ++i) {
            try {
                String key = an.key(i);
                String statVal = an.value(i);
                if (!key.toLowerCase().startsWith("stat.") && !key.toLowerCase().startsWith("stat:")) continue;
                String statKey = key.substring(5);
                if (statVal.equalsIgnoreCase("false")) {
                    stat.remove(statKey);
                    continue;
                }
                if ("Overflow".equals(statKey) && (Integer)this.getExtendedStatistic(statKey) == 0 || "Underflow".equals(statKey) && (Integer)this.getExtendedStatistic(statKey) == 0) continue;
                if ("OutOfRange".equals(statKey)) {
                    isOutOfRangeSet = true;
                    continue;
                }
                stat.add(statKey);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (!isOutOfRangeSet && (stat.contains("Overflow") || stat.contains("Underflow"))) {
            stat.remove("OutOfRange");
        }
    }
}

