/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal;

import java.time.Duration;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALException;
import org.lsst.sal.SALHasErrorCode;

public abstract class SALReceivedCommand<C extends SALCommand> {
    private final int cmdId;
    private final C command;

    protected SALReceivedCommand(int cmdId, C command) {
        this.cmdId = cmdId;
        this.command = command;
    }

    public abstract void acknowledgeCommand(Duration var1) throws SALException;

    public abstract void reportComplete() throws SALException;

    public void reportError(Exception ex) throws SALException {
        int errorCode = 0;
        if (ex instanceof SALHasErrorCode) {
            errorCode = ((SALHasErrorCode)((Object)ex)).getErrorCode();
        }
        if (ex.getMessage() != null) {
            this.reportError(errorCode, ex.getMessage());
        } else {
            this.reportError(errorCode, ex.toString());
        }
    }

    public abstract void reportError(int var1, String var2) throws SALException;

    public abstract void rejectCommand(String var1, int var2) throws SALException;

    public int getCmdId() {
        return this.cmdId;
    }

    public C getCommand() {
        return this.command;
    }
}

