/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.mcc.MccUsb;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class MCCDevice
extends Device {
    static final int N_DEV_CHANS = 8;
    static final float[] RTD_COEFFS = new float[]{100.0f, 0.003908f, -5.8019E-7f, -4.2735E-12f};
    private static final Map<String, Integer> didMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> typeMap;
    private static final Map<String, Integer> tSbTypMap;
    private static final Map<String, Integer> tcSbTypMap;
    private static final Map<String, Integer> rtSbTypMap;
    private static final Map<String, Integer> vSbTypMap;
    private String devName;
    private String serial;
    private static final Logger LOG;
    private int did;
    private final MccUsb mcc = new MccUsb();
    private int tcMask;
    private int rtMask;
    private int vMask;
    private boolean initError = false;

    public MCCDevice(String dName, String serialNo) {
        this.devName = dName;
        this.serial = serialNo;
    }

    public MCCDevice() {
    }

    protected void initDevice() {
        Integer iDid;
        if (this.devName == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"devName", (String)"is missing");
        }
        if ((iDid = didMap.get(this.devName)) == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"devName", (String)("is invalid: " + this.devName));
        }
        this.did = iDid;
        if (this.did == 0) {
            this.tcMask = 15;
            this.vMask = 240;
        } else if (this.did == 1) {
            this.tcMask = 255;
        } else if (this.did == 2) {
            this.tcMask = 255;
            this.rtMask = 255;
        }
        this.fullName = "MCC " + this.devName + " module" + (this.serial == null ? "" : " (" + this.serial + ")");
    }

    protected void initialize() {
        try {
            int j;
            this.mcc.open(this.did, this.serial, true);
            this.mcc.blink();
            int line = 0;
            int mask = this.lineMask;
            while (line < 8) {
                this.mcc.dioConfigBit(line, 1 - (mask & 1));
                ++line;
                mask >>= 1;
            }
            if (this.did == 0) {
                for (j = 0; j < 8; ++j) {
                    this.mcc.configAlarm(j, 0, 0, 0.0f, 0.0f);
                }
            } else if (this.did == 2) {
                for (j = 0; j < 8; j += 2) {
                    this.mcc.setSensorType(j, 4);
                }
            }
            this.initSensors();
            this.setOutputLines();
            LOG.log(Level.INFO, "Connected to {0}", this.fullName);
            this.initError = false;
            this.setOnline(true);
        }
        catch (DriverException | ChannelInitializationException e) {
            if (!this.initError) {
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
            try {
                this.mcc.close();
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
    }

    protected void close() {
        try {
            this.mcc.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        String type = ch.getTypeStr();
        Integer iSubtype = 0;
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"type", (Object)type);
        }
        String subtype = ch.getSubTypeStr();
        String sbtype = subtype.toUpperCase();
        if (iType == 0) {
            Integer iStp;
            String[] sbtypes = sbtype.split(":", -1);
            if (sbtypes.length < 2) {
                ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"subtype", (Object)subtype);
            }
            if ((iSubtype = tSbTypMap.get(sbtypes[0])) == null) {
                ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"subtype", (Object)subtype);
            }
            Integer n = iStp = iSubtype == 0 ? rtSbTypMap.get(sbtypes[1]) : tcSbTypMap.get(sbtypes[1]);
            if (iStp == null) {
                ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"subtype", (Object)subtype);
            }
            iSubtype = iSubtype | iStp << 8;
        } else if (iType == 1 && (iSubtype = vSbTypMap.get(sbtype)) == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"subtype", (Object)subtype);
        }
        boolean chanOk = true;
        int hwChan = ch.getHwChan();
        if (iType == 0) {
            int mask;
            int n = mask = (iSubtype & 0xFF) == 0 ? this.rtMask : this.tcMask;
            if ((1 << hwChan & mask) == 0) {
                chanOk = false;
            }
        } else if (iType == 1) {
            if ((1 << hwChan & this.vMask) == 0) {
                chanOk = false;
            }
        } else if (hwChan < 0 || hwChan >= 8) {
            chanOk = false;
        }
        if (!chanOk) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"hw channel number", (Object)hwChan);
        }
        return new int[]{iType, iSubtype};
    }

    protected void initChannel(Channel ch) {
        try {
            int type = ch.getType();
            int subtype = ch.getSubType();
            int hwChan = ch.getHwChan();
            if (type == 0) {
                int sType = subtype & 0xFF;
                int tType = subtype >> 8;
                this.mcc.setSensorType(hwChan, sType);
                if (sType == 0) {
                    this.mcc.setThermConnType(hwChan, tType);
                    this.mcc.setExcitation(hwChan, 2);
                    this.mcc.setGain(hwChan, 2);
                    this.mcc.setGain(hwChan + 1, 2);
                    for (int j = 0; j < RTD_COEFFS.length; ++j) {
                        this.mcc.setCoefficient(hwChan, j, RTD_COEFFS[j]);
                    }
                } else {
                    this.mcc.setTCType(hwChan, tType);
                }
            } else if (type == 1) {
                this.mcc.setGain(hwChan, subtype);
                this.mcc.setVoltageConnType(hwChan, 0);
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error configuring {0}: {1}", new Object[]{this.fullName, e});
            throw new ChannelInitializationException(e);
        }
    }

    protected double readChannel(Channel ch) {
        if (this.isOnline()) {
            if (ch.getType() == 3) {
                try {
                    return this.mcc.dioInBit(ch.getHwChan());
                }
                catch (DriverException e) {
                    LOG.log(Level.SEVERE, "Error reading DIO line: {0}", e);
                    this.setOnline(false);
                }
            } else {
                try {
                    return this.mcc.adcIn(ch.getHwChan(), 0);
                }
                catch (DriverException e) {
                    LOG.log(Level.SEVERE, "Error reading ADC: {0}", e);
                    this.setOnline(false);
                }
            }
        }
        return Double.NaN;
    }

    protected void checkHwLine(String name, int line) throws Exception {
        if (line < 0 || line >= 8) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"line", (Object)line);
        }
        this.addLine(line);
    }

    protected void setHwLine(int line, boolean on) {
        try {
            this.mcc.dioOutBit(line, on ? 1 : 0);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error setting DIO line: {0}", e);
            this.setOnline(false);
        }
    }

    protected Boolean isHwLineSet(int line) {
        try {
            return this.mcc.dioInBit(line) != 0;
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error reading DIO line: {0}", e);
            this.setOnline(false);
            return false;
        }
    }

    static {
        didMap.put("TC_AI", 0);
        didMap.put("TC", 1);
        didMap.put("TEMP", 2);
        typeMap = new HashMap<String, Integer>();
        typeMap.put("TEMP", 0);
        typeMap.put("VOLTS", 1);
        typeMap.put("SWITCH", 3);
        tSbTypMap = new HashMap<String, Integer>();
        tSbTypMap.put("TC", 2);
        tSbTypMap.put("RTD", 0);
        tcSbTypMap = new HashMap<String, Integer>();
        tcSbTypMap.put("J", 0);
        tcSbTypMap.put("K", 1);
        tcSbTypMap.put("T", 2);
        tcSbTypMap.put("E", 3);
        tcSbTypMap.put("R", 4);
        tcSbTypMap.put("S", 5);
        tcSbTypMap.put("B", 6);
        tcSbTypMap.put("N", 7);
        rtSbTypMap = new HashMap<String, Integer>();
        rtSbTypMap.put("2WIRE1", 0);
        rtSbTypMap.put("2WIRE2", 1);
        rtSbTypMap.put("3WIRE", 2);
        rtSbTypMap.put("4WIRE", 3);
        vSbTypMap = new HashMap<String, Integer>();
        vSbTypMap.put("10V", 2);
        vSbTypMap.put("5V", 3);
        vSbTypMap.put("2.5V", 4);
        vSbTypMap.put("1.25V", 5);
        LOG = Logger.getLogger(MCCDevice.class.getName());
    }

    private class ChannelInitializationException
    extends RuntimeException {
        public ChannelInitializationException(DriverException ex) {
            super(ex);
        }
    }
}

