/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public final class FcsUtils {
    private static final Logger FCSLOG = Logger.getLogger(FcsUtils.class.getName());
    public static final int MAX_VALUE_2BYTES = 65535;
    public static final int MAX_NODE_ID = 127;
    public static final int TICK_MILLIS = 3000;
    private static final String[] CAN_OPEN_COMMANDS = new String[]{"sync", "scan", "rsdo", "wsdo", "info", "quit", "srtr", "reset"};
    static ThreadLocal<ConcurrentLinkedDeque<TimingEntry>> localStack = new ThreadLocal<ConcurrentLinkedDeque<TimingEntry>>(){

        @Override
        protected ConcurrentLinkedDeque<TimingEntry> initialValue() {
            return new ConcurrentLinkedDeque<TimingEntry>();
        }
    };
    static ExecutorService execSvc = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        }
    });
    static boolean simuTested = false;
    static boolean simu = false;
    private static String defaultTimedLoggerLevelAsString = "FINE";

    public static void checkSocketName(String name) {
        String errorMsg = ": invalid socket name - Socket name must be \"socketX\" where 0 <= X <= 5";
        if (name.isEmpty() || name.contentEquals("AC")) {
            return;
        }
        if (!name.startsWith("socket")) {
            throw new IllegalArgumentException(name + errorMsg);
        }
        String end = name.substring(6);
        try {
            int ix = Integer.parseInt(end);
            if (ix < 1 || ix > 5) {
                throw new IllegalArgumentException(name + errorMsg);
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(name + errorMsg, ex);
        }
    }

    public static int force2zero(int val, int bit) {
        if (bit < 0 || bit > 15) {
            throw new IllegalArgumentException(String.format("bad value for bit=%s - must be : >0 and <15", bit));
        }
        return val & ~(1 << bit);
    }

    public static int force2one(int val, int bit) {
        if (bit < 0 || bit > 15) {
            throw new IllegalArgumentException(String.format("bad value for bit=%s - must be : >0 and <15", bit));
        }
        return val | 1 << bit;
    }

    public static int forceBit(int val, int bit, int zeroOne) {
        if (zeroOne == 0) {
            return FcsUtils.force2zero(val, bit);
        }
        return FcsUtils.force2one(val, bit);
    }

    public static String buildWsdoCommand(int nodeID, int index, int subindex, int size, int data) {
        char sep = ',';
        StringBuilder sb = new StringBuilder("wsdo").append(sep);
        sb.append(Integer.toHexString(nodeID)).append(sep);
        sb.append(Integer.toHexString(index)).append(sep);
        sb.append(Integer.toHexString(subindex)).append(sep);
        sb.append(Integer.toHexString(size)).append(sep);
        sb.append(Integer.toHexString(data));
        return sb.toString();
    }

    public static String buildRsdoCommand(int nodeID, int index, int subindex) {
        char sep = ',';
        StringBuilder sb = new StringBuilder("rsdo").append(sep);
        sb.append(Integer.toHexString(nodeID)).append(sep);
        sb.append(Integer.toHexString(index)).append(sep);
        sb.append(Integer.toHexString(subindex));
        return sb.toString();
    }

    public static boolean isValidCommandWord(String command) {
        for (String s : CAN_OPEN_COMMANDS) {
            if (!s.equals(command)) continue;
            return true;
        }
        return false;
    }

    public static void checkCommand(String command) {
        if (command == null) {
            throw new IllegalArgumentException(" null command");
        }
        String[] words = command.split(",");
        if (words.length == 0 || !FcsUtils.isValidCommandWord(words[0])) {
            throw new IllegalArgumentException(command + " invalid command");
        }
    }

    public static byte convertInteger8(long integer8) {
        if ((double)integer8 >= Math.pow(2.0, 8.0)) {
            throw new IllegalArgumentException(integer8 + " too big. Should be coded on 8 bits, so < Math.pow(2,8)");
        }
        return (byte)integer8;
    }

    public static short convertInteger16(long integer16) {
        if ((double)integer16 >= Math.pow(2.0, 16.0)) {
            throw new IllegalArgumentException(integer16 + " too big. Should be coded on 16 bits, so < Math.pow(2,16)");
        }
        return (short)integer16;
    }

    public static int convertInteger32(long integer32) {
        if ((double)integer32 >= Math.pow(2.0, 32.0)) {
            throw new IllegalArgumentException(integer32 + " too big. Should be coded on 32 bits, so < Math.pow(2,32)");
        }
        return (int)integer32;
    }

    public static String displayListParameters(String modeInString) {
        EPOSEnumerations.Parameter[] params;
        StringBuilder sb = new StringBuilder("List of parameters for mode: ");
        sb.append(modeInString);
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = EPOSEnumerations.EposMode.valueOf(modeInString).getParameters()) {
            sb.append(param.display());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String displayListParameters() {
        EPOSEnumerations.Parameter[] params;
        StringBuilder sb = new StringBuilder("List of parameters : ");
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = EPOSEnumerations.Parameter.values()) {
            sb.append(param.display());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static int getSignedStepHeight(int initialValue, int finalValue, int increment) {
        if (finalValue - initialValue > 0) {
            return increment;
        }
        return -increment;
    }

    public static void main(String[] args) {
        System.out.println(FcsUtils.displayListParameters("HOMING"));
        System.out.println(FcsUtils.displayListParameters("CURRENT"));
        System.out.println(FcsUtils.displayListParameters("PROFILE_POSITION"));
        System.out.println(FcsUtils.displayListParameters());
    }

    public static int computeNewCurrentValue(int stepHeight, int currentValue, int finalValue) {
        if (stepHeight > 0) {
            return Math.min(currentValue + stepHeight, finalValue);
        }
        return Math.max(currentValue + stepHeight, finalValue);
    }

    public static void sleep(int duration, String itemName) {
        try {
            FCSLOG.finest(() -> itemName + " BEGIN SLEEP for " + duration + " milliseconds");
            FcsUtils.reportSleep(duration);
            Thread.sleep(duration);
            FCSLOG.finest(() -> itemName + " END SLEEP for " + duration + " milliseconds");
        }
        catch (InterruptedException ex) {
            String msg = itemName + " interrupted while sleeping";
            FCSLOG.log(Level.SEVERE, itemName + msg, ex);
        }
    }

    public static void checkPositive(int arg) {
        if (arg < 0) {
            throw new IllegalArgumentException(arg + ":illegal value. Must be > 0");
        }
    }

    public static int returnPlutoIndex(int byteNumero) {
        int index = 24576 + byteNumero / 4;
        return index;
    }

    public static int returnPlutoSubindex(int byteNumero) {
        int subindex = 1 + byteNumero % 4;
        return subindex;
    }

    public static void checkAndWaitConditionWithTimeout(Callable<Boolean> condition, Runnable update, String name, String error, long timeout) {
        try (AutoTimed at = new AutoTimed(name);){
            long startTime = System.currentTimeMillis();
            long delay = 10L;
            while (System.currentTimeMillis() - startTime < timeout) {
                try {
                    if (condition.call().booleanValue()) {
                        return;
                    }
                }
                catch (Exception e) {
                    throw new RejectedCommandException("failed predicate test for " + error + " " + e.getMessage());
                }
                if (update != null) {
                    update.run();
                }
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((delay *= 2L) <= 200L) continue;
                delay = 200L;
            }
            throw new RejectedCommandException(error);
        }
    }

    public static void checkAndWaitCondition(Callable<Boolean> condition, Runnable update, String name, String error) {
        FcsUtils.checkAndWaitConditionWithTimeout(condition, update, name, error, 1000L);
    }

    public static void checkAndWaitConditionWithTimeoutAndFixedDelay(Callable<Boolean> condition, Runnable update, String name, String error, long timeout, long delay) {
        try (AutoTimed at = new AutoTimed(name);){
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < timeout) {
                try {
                    if (condition.call().booleanValue()) {
                        return;
                    }
                }
                catch (Exception e) {
                    throw new RejectedCommandException("failed predicate test for " + error + " " + e.getMessage());
                }
                if (update != null) {
                    update.run();
                }
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {}
            }
            throw new RejectedCommandException(error);
        }
    }

    public static void waitCondition(Callable<Boolean> condition, Runnable update, String name, long timeout) {
        try (AutoTimed at = new AutoTimed(name);){
            long startTime = System.currentTimeMillis();
            long delay = 10L;
            while (System.currentTimeMillis() - startTime < timeout) {
                try {
                    if (condition.call().booleanValue()) {
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (update != null) {
                    update.run();
                }
                if ((delay *= 2L) <= 200L) continue;
                delay = 200L;
            }
        }
    }

    public static int getTimingLevel() {
        return localStack.get().peek() == null ? 0 : localStack.get().peek().getIndentationLevel();
    }

    public static Level getLogLevel() {
        return FcsUtils.getLogLevel(Level.parse(defaultTimedLoggerLevelAsString));
    }

    public static Level getLogLevel(Level defaultLevel) {
        return localStack.get().peek() == null ? defaultLevel : localStack.get().peek().getLogLevel();
    }

    static boolean isAsync() {
        return localStack.get().peek() != null && localStack.get().peek().isAsync();
    }

    static void startTimedAction(String actionName, Level logLevel) {
        Level parentLevel = FcsUtils.getLogLevel(logLevel);
        localStack.get().push(new TimingEntry(actionName, FcsUtils.getTimingLevel() + 1, FcsUtils.isAsync(), parentLevel));
        int space = FcsUtils.getTimingLevel() * 2;
        String out = String.format("%1s%" + space + "s start timed %s", FcsUtils.isAsync() ? "x" : ">", " ", actionName);
        FCSLOG.log(parentLevel, out);
    }

    static void endTimedAction(String actionName) {
        int space = FcsUtils.getTimingLevel() * 2;
        TimingEntry te = localStack.get().pop();
        if (te == null) {
            FCSLOG.warning("endTimedAction not balanced for " + actionName);
            return;
        }
        String out = String.format("%1s%" + space + "s end timed   %s duration %d ms incl sleep %d ms", te.isAsync() ? "x" : ">", " ", actionName, te.getDuration(), te.getSleep());
        FCSLOG.log(te.getLogLevel(), out);
        FcsUtils.reportSleep(te.getSleep());
    }

    public static void startAsync(int level, Level logLevel) {
        Level parentLevel = FcsUtils.getLogLevel(logLevel);
        localStack.get().push(new TimingEntry("async", level + 1, true, parentLevel));
        int space = level * 2 + 2;
        String out = String.format("x%" + space + "s start timed %s", " ", "async");
        FCSLOG.log(parentLevel, out);
    }

    public static void endAsync() {
        FcsUtils.endTimedAction("async");
    }

    static void reportSleep(long ms) {
        TimingEntry te = localStack.get().peek();
        if (te != null) {
            te.reportSleep(ms);
        }
    }

    public static void parallelRun(Runnable ... tasks) {
        AsyncTasks t = new AsyncTasks();
        for (Runnable task : tasks) {
            t.asyncRun(task);
        }
        t.await();
    }

    public static AsyncTasks asyncRun(Runnable task) {
        return new AsyncTasks().asyncRun(task);
    }

    public static AsyncTasks asyncRun() {
        return new AsyncTasks();
    }

    public static boolean isJUnitTest() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().startsWith("org.junit.")) continue;
            return true;
        }
        return false;
    }

    public static boolean isSimu() {
        if (!simuTested) {
            Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
            simu = "simulation".equals(props.getProperty("org.lsst.ccs.run.mode"));
            if (!simu) {
                simu = FcsUtils.isJUnitTest();
            }
            simuTested = true;
        }
        return simu;
    }

    public static void setDefaultTimedLoggerLevel(String levelName) {
        defaultTimedLoggerLevelAsString = levelName;
    }

    public static String getDefaultTimedLoggerLevel() {
        return defaultTimedLoggerLevelAsString;
    }

    public static class AutoTimed
    implements AutoCloseable {
        String name;
        Level logLevel;

        public AutoTimed(String name) {
            this(name, Level.parse(defaultTimedLoggerLevelAsString));
        }

        public AutoTimed(String name, Level logLevel) {
            this.name = name;
            this.logLevel = logLevel;
            FcsUtils.startTimedAction(name, logLevel);
        }

        @Override
        public void close() {
            FcsUtils.endTimedAction(this.name);
        }
    }

    static class TimingEntry {
        private String name;
        private long start = System.currentTimeMillis();
        private long sleep = 0L;
        private int indentationLevel;
        private boolean async;
        private Level logLevel;

        public TimingEntry(String name, int indentationLevel, boolean async, Level logLevel) {
            this.name = name;
            this.indentationLevel = indentationLevel;
            this.async = async;
            this.logLevel = logLevel;
        }

        public long getDuration() {
            return System.currentTimeMillis() - this.start;
        }

        public long getSleep() {
            return this.sleep;
        }

        public synchronized void reportSleep(long s) {
            this.sleep += s;
        }

        public String getName() {
            return this.name;
        }

        public boolean isAsync() {
            return this.async;
        }

        public int getIndentationLevel() {
            return this.indentationLevel;
        }

        public Level getLogLevel() {
            return this.logLevel;
        }
    }

    public static class AsyncTasks {
        List<Future<?>> f = new ArrayList();
        int level = FcsUtils.getTimingLevel();
        Level logLevel = FcsUtils.getLogLevel(Level.parse(FcsUtils.access$000()));

        public AsyncTasks asyncRun(Runnable task) {
            Runnable r = () -> {
                FcsUtils.startAsync(this.level, this.logLevel);
                task.run();
                FcsUtils.endAsync();
            };
            this.f.add(execSvc.submit(r));
            return this;
        }

        public void await() {
            for (Future<?> ff : this.f) {
                try {
                    ff.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

