/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.plc.Tools;

public class ChangeBrakeState
extends MsgToPLC {
    private final Axis axis;
    private final State state;

    public ChangeBrakeState(Axis axis, State state) {
        this.axis = axis;
        this.state = state;
    }

    public ChangeBrakeState(ByteBuffer data) {
        super(data);
        this.axis = Axis.fromAxisNum(data.getInt());
        this.state = Tools.getBoolean(data) ? State.ENGAGED : State.RELEASED;
    }

    @Override
    public void encode(ByteBuffer data) {
        super.encode(data);
        data.putInt(this.axis.getPLCAxisNum());
        Tools.putBoolean(data, this.state == State.ENGAGED);
    }

    public State getState() {
        return this.state;
    }

    public Axis getAxis() {
        return this.axis;
    }

    @Override
    public String toString() {
        return "ChangeBrakeState{" + super.toString() + " axis=" + (Object)((Object)this.axis) + ", state=" + (Object)((Object)this.state) + '}';
    }

    public static enum State {
        ENGAGED,
        RELEASED;

    }
}

