/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.SupportedOption;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.annotations.Option;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.data.RaftException;

public class RebPowerOnOffCommands {
    private static final Logger LOG = Logger.getLogger(RebPowerOnOffCommands.class.getName());
    private final SupportedOption noShortsTestOption = SupportedOption.getSupportedOption((String)"noShortsTest");
    private final SupportedOption dryRunOption = SupportedOption.getSupportedOption((String)"dryRun");
    private final FocalPlaneSubsystem focalPlane;

    RebPowerOnOffCommands(FocalPlaneSubsystem focalPlane) {
        this.focalPlane = focalPlane;
    }

    @Option.List(value={@Option(name="noShortsTest", description="If set to true it will skip the shorts test"), @Option(name="dryRun", description="If set to true the command will not execute any commands on the Rebs")})
    @Command(description="Power on a specified set of Rebs", type=Command.CommandType.ACTION, level=1)
    public void powerOnCCDs(Options options, @Argument String regEx, @Argument(defaultValue="30", description="number of seconds to wait between rebs") int delay) throws RaftException {
        Pattern rebPattern = Pattern.compile(regEx);
        boolean noShortsTest = options.hasOption(this.noShortsTestOption);
        boolean dryRun = options.hasOption(this.dryRunOption);
        LOG.log(Level.INFO, "Execuring powerOnCCDs for Rebs matching regular expression \"{0}\" with delay of {1} seconds between Rebs. Skip Shorts Test = {2}. Dry Run = {3}", new Object[]{regEx, delay, noShortsTest, dryRun});
        for (Map.Entry<String, REBDevice> e : this.focalPlane.getRebDevices().entrySet()) {
            if (!rebPattern.matcher(e.getKey()).matches()) continue;
            REBDevice device = e.getValue();
            if (device.isBackBiasDisabled()) {
                LOG.log(Level.INFO, "Skipping Reb: {0} as it's already on.", e.getKey());
                continue;
            }
            LOG.log(Level.INFO, "Starting Power on sequence for Reb: {0}", e.getKey());
            if (!noShortsTest) {
                LOG.log(Level.INFO, "Performing shorts test on Reb: {0}", e.getKey());
                if (!dryRun) {
                    device.testCCDShorts();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            LOG.log(Level.INFO, "Invoking powerCCDsOn on Reb: {0}", e.getKey());
            if (!dryRun) {
                device.powerCCDsOn();
            }
            try {
                Thread.sleep((long)delay * 1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Option.List(value={@Option(name="noShortsTest", description="If set to true it will skip the shorts test"), @Option(name="dryRun", description="If set to true the command will not execute any commands on the Rebs")})
    @Command(description="Power off a specified set of Rebs", type=Command.CommandType.ACTION, level=1)
    public void powerOffCCDs(Options options, @Argument String regEx, @Argument(defaultValue="30", description="number of seconds to wait between rebs") int delay) throws RaftException {
        Pattern rebPattern = Pattern.compile(regEx);
        boolean noShortsTest = options.hasOption(this.noShortsTestOption);
        boolean dryRun = options.hasOption(this.dryRunOption);
        LOG.log(Level.INFO, "Execuring powerOffCCDs for Rebs matching regular expression \"{0}\" with delay of {1} seconds between Rebs. Skip Shorts Test = {2}. Dry Run = {3}", new Object[]{regEx, delay, noShortsTest, dryRun});
        for (Map.Entry<String, REBDevice> e : this.focalPlane.getRebDevices().entrySet()) {
            if (!rebPattern.matcher(e.getKey()).matches()) continue;
            REBDevice device = e.getValue();
            if (!device.isBackBiasDisabled()) {
                LOG.log(Level.INFO, "Skipping Reb: {0} as it's already of.", e.getKey());
                continue;
            }
            LOG.log(Level.INFO, "Starting Power off sequence for Reb: {0}", e.getKey());
            if (!noShortsTest) {
                LOG.log(Level.INFO, "Performing shorts test on Reb: {0}", e.getKey());
                if (!dryRun) {
                    device.testCCDShorts();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            LOG.log(Level.INFO, "Invoking powerCCDsOff on Reb: {0}", e.getKey());
            if (!dryRun) {
                device.powerCCDsOff();
            }
            try {
                Thread.sleep((long)delay * 1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

