import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.mmm.GenericMMM;
import org.lsst.ccs.subsystem.mmm.Minion;
import org.lsst.ccs.subsystem.mmm.MinionGroup;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.AlertHandler;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.AlertAction;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.EmailAlertAction;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.EmailAlertDeliveryStrategy;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher;
import org.lsst.ccs.subsystem.mmm.AlertNotification;
import org.lsst.ccs.subsystem.mmm.DaqMonitorPrivateEmailAction;
import org.lsst.ccs.subsystem.mmm.SquadcastAlertAction;
import org.lsst.ccs.bus.states.AlertState;
import java.util.function.Predicate;
import java.time.Duration;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

CCSBuilder builder = ["mmm"]


Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
String mmm_type = props.getProperty("org.lsst.ccs.subsystem.agent.property.cluster","generic");

System.out.println("Building MMM of type "+mmm_type);

builder.
    main(GenericMMM) {
    
    infrastructure (AlertDispatcher) {
        infrastructureEmailNotification (AlertHandler) {
            infrastructurePublicMailAction (EmailAlertAction) {
                localDbEmailStrategy (EmailAlertDeliveryStrategy)
                defaultEmailStrategy (EmailAlertDeliveryStrategy)
            }
            infrastructureSquadcastAction (SquadcastAlertAction) 
        }        
    }
    
    if ( mmm_type.equals("ir2") ) {
        environment (AlertDispatcher) {
            environmentEmailNotification (AlertHandler) {
                environmentPublicMailAction (EmailAlertAction)
            }        
        }
        
        ts71gTest (AlertDispatcher) {
            ts71gEmailNotification (AlertHandler) {
                publicMailAction (EmailAlertAction)
            }
            ts71gSquadcastAction (SquadcastAlertAction) 
        }        
    } else if ( mmm_type.equals("comcam") ) {
        comcam (AlertDispatcher) {
            comcamEmailNotification (AlertHandler) {
                comcamPublicMailAction (EmailAlertAction)
                comcamSquadcastAction (SquadcastAlertAction) 
            }        
        }        

        pathfinder (AlertDispatcher) {
            pathfinderEmailNotification (AlertHandler) {
                pathfinderPublicMailAction (EmailAlertAction)
            }        
        }        
    } else if (mmm_type.equals("ats") ) {
        ats (AlertDispatcher) {
            atsEmailNotification (AlertHandler) {
                atsPublicMailAction (EmailAlertAction)
                atsSquadcastAction (SquadcastAlertAction) 
            }        
        }        
    } else if (mmm_type.equals("camera") ) {
        camera (AlertDispatcher) {
            cameraEmailNotification (AlertHandler) {
                daqMonitorPrivateEmailAction(DaqMonitorPrivateEmailAction) {
                    daqMonitorEmailStrategy (EmailAlertDeliveryStrategy)                    
                }
                cameraPublicMailAction (EmailAlertAction) {
                    focalPlaneEmailStrategy (EmailAlertDeliveryStrategy)
                    defaultEmailStrategy (EmailAlertDeliveryStrategy)                 
                }
                cameraSquadcastAction (SquadcastAlertAction) 
            }
	}
    }
}
