/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling.data;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;

@SkipEncoding
public class TextFile
extends AdditionalFile {
    private final String text;
    private final String commentDelimiter;
    private final boolean includeStandardHeader;
    private static final long serialVersionUID = 1L;
    static final String MIME_TYPE = "text/plain";

    public TextFile(String text, String fileName, String fileType, ImageName obsId) {
        this(text, "#", true, fileName, fileType, obsId);
    }

    public TextFile(String text, String commentDelimiter, boolean includeStandardHeader, String fileName, String fileType, ImageName obsId) {
        super(fileName, fileType, obsId, 1.0f, MIME_TYPE);
        this.text = text;
        this.commentDelimiter = commentDelimiter;
        this.includeStandardHeader = includeStandardHeader;
    }

    @Override
    public void writeFile(OutputStream out) throws IOException {
        try (PrintStream ps = new PrintStream(out);){
            if (this.includeStandardHeader) {
                ps.println(this.commentDelimiter);
                ps.printf("%s ObsId: %s\n", this.commentDelimiter, this.getObsId());
                ps.printf("%s FileName: %s\n", this.commentDelimiter, this.getFileName());
                ps.printf("%s FileType: %s\n", this.commentDelimiter, this.getFileType());
                ps.printf("%s Version: %s\n", this.commentDelimiter, Float.valueOf(this.getVersion()));
                ps.println(this.commentDelimiter);
            }
            ps.print(this.text);
        }
    }
}

