/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.annotations.Experimental;
import org.jgroups.protocols.TransferQueueBundler;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Util;

@Experimental
public class AlternatingBundler
extends TransferQueueBundler
implements DiagnosticsHandler.ProbeHandler {
    protected Address target_dest;
    protected final List<Message> target_list = new ArrayList<Message>();
    protected final AverageMinMax avg_batch_size = new AverageMinMax();

    @Override
    public synchronized void start() {
        super.start();
        this.transport.registerProbeHandler(this);
    }

    @Override
    public synchronized void stop() {
        this.transport.unregisterProbeHandler(this);
        super.stop();
    }

    @Override
    public void run() {
        while (this.running) {
            Message msg = null;
            try {
                msg = (Message)this.queue.take();
                if (msg == null) continue;
                long size = msg.size();
                if (this.count + size >= (long)this.transport.getMaxBundleSize()) {
                    ++this.num_sends_because_full_queue;
                    this.avg_fill_count.add(this.count);
                    this._sendBundledMessages();
                }
                while (true) {
                    Address dest;
                    if (!Util.match(dest = msg.dest(), this.target_dest) || this.count + size >= (long)this.transport.getMaxBundleSize()) {
                        this._sendBundledMessages();
                    }
                    this._addMessage(msg, size);
                    msg = (Message)this.queue.poll();
                    if (msg == null) break;
                    size = msg.size();
                }
                this._sendBundledMessages();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public Map<String, String> handleProbe(String ... keys) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = keys;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String key;
            switch (key = stringArray[i]) {
                case "ab.avg_batch_size": {
                    map.put(key, this.avg_batch_size.toString());
                    continue block8;
                }
                case "ab.avg_batch_size.reset": {
                    this.avg_batch_size.clear();
                }
            }
        }
        return map;
    }

    @Override
    public String[] supportedKeys() {
        return new String[]{"ab.avg_batch_size", "ab.avg_batch_size.reset"};
    }

    @Override
    protected void _sendBundledMessages() {
        try {
            if (this.target_list.isEmpty()) {
                return;
            }
            this.output.position(0);
            if (this.target_list.size() == 1) {
                this.sendSingleMessage(this.target_list.get(0));
            } else {
                this.avg_batch_size.add(this.target_list.size());
                this.sendMessageList(this.target_dest, this.target_list.get(0).getSrc(), this.target_list);
                if (this.transport.statsEnabled()) {
                    this.transport.incrBatchesSent(1);
                }
            }
        }
        finally {
            this.target_list.clear();
            this.count = 0L;
        }
    }

    @Override
    protected void _addMessage(Message msg, long size) {
        this.target_dest = msg.dest();
        this.target_list.add(msg);
        this.count += size;
    }
}

