/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Constructable;
import org.jgroups.Header;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.util.Buffer;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.Headers;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Message
implements Streamable,
Constructable<Message> {
    protected Address dest;
    protected Address sender;
    protected byte[] buf;
    protected int offset;
    protected int length;
    protected volatile Header[] headers;
    protected volatile short flags;
    protected volatile byte transient_flags;
    static final byte DEST_SET = 1;
    static final byte SRC_SET = 2;
    static final byte BUF_SET = 4;

    public Message(Address dest) {
        this.setDest(dest);
        this.headers = Message.createHeaders(Util.DEFAULT_HEADERS);
    }

    public Message(Address dest, byte[] buf) {
        this(dest, buf, 0, buf != null ? buf.length : 0);
    }

    public Message(Address dest, byte[] buf, int offset, int length) {
        this(dest);
        this.setBuffer(buf, offset, length);
    }

    public Message(Address dest, Buffer buf) {
        this(dest);
        this.setBuffer(buf);
    }

    public Message(Address dest, Object obj) {
        this(dest);
        this.setObject(obj);
    }

    public Message() {
        this(true);
    }

    public Message(boolean create_headers) {
        if (create_headers) {
            this.headers = Message.createHeaders(Util.DEFAULT_HEADERS);
        }
    }

    @Override
    public Supplier<? extends Message> create() {
        return Message::new;
    }

    public Address getDest() {
        return this.dest;
    }

    public Address dest() {
        return this.dest;
    }

    public Message setDest(Address new_dest) {
        this.dest = new_dest;
        return this;
    }

    public Message dest(Address new_dest) {
        this.dest = new_dest;
        return this;
    }

    public Address getSrc() {
        return this.sender;
    }

    public Address src() {
        return this.sender;
    }

    public Message setSrc(Address new_src) {
        this.sender = new_src;
        return this;
    }

    public Message src(Address new_src) {
        this.sender = new_src;
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public int offset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int length() {
        return this.length;
    }

    public byte[] getRawBuffer() {
        return this.buf;
    }

    public byte[] rawBuffer() {
        return this.buf;
    }

    public byte[] buffer() {
        return this.getBuffer();
    }

    public Buffer buffer2() {
        return this.getBuffer2();
    }

    public Message buffer(byte[] b) {
        return this.setBuffer(b);
    }

    public Message buffer(Buffer b) {
        return this.setBuffer(b);
    }

    public int getNumHeaders() {
        return Headers.size(this.headers);
    }

    public int numHeaders() {
        return Headers.size(this.headers);
    }

    public byte[] getBuffer() {
        if (this.buf == null) {
            return null;
        }
        if (this.offset == 0 && this.length == this.buf.length) {
            return this.buf;
        }
        byte[] retval = new byte[this.length];
        System.arraycopy(this.buf, this.offset, retval, 0, this.length);
        return retval;
    }

    public Buffer getBuffer2() {
        if (this.buf == null) {
            return null;
        }
        return new Buffer(this.buf, this.offset, this.length);
    }

    public Message setBuffer(byte[] b) {
        this.buf = b;
        if (this.buf != null) {
            this.offset = 0;
            this.length = this.buf.length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
        return this;
    }

    public Message setBuffer(byte[] b, int offset, int length) {
        this.buf = b;
        if (this.buf != null) {
            if (offset < 0 || offset > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            if (offset + length > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset + length);
            }
            this.offset = offset;
            this.length = length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
        return this;
    }

    public Message setBuffer(Buffer buf) {
        if (buf != null) {
            this.buf = buf.getBuf();
            this.offset = buf.getOffset();
            this.length = buf.getLength();
        }
        return this;
    }

    public Map<Short, Header> getHeaders() {
        return Headers.getHeaders(this.headers);
    }

    public String printHeaders() {
        return Headers.printHeaders(this.headers);
    }

    public Message setObject(Object obj) {
        if (obj == null) {
            return this;
        }
        if (obj instanceof byte[]) {
            return this.setBuffer((byte[])obj);
        }
        if (obj instanceof Buffer) {
            return this.setBuffer((Buffer)obj);
        }
        try {
            return this.setBuffer(Util.objectToByteBuffer(obj));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public <T> T getObject() {
        return this.getObject(null);
    }

    public <T> T getObject(ClassLoader loader) {
        try {
            return Util.objectFromByteBuffer(this.buf, this.offset, this.length, loader);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public Message setFlag(Flag ... flags) {
        if (flags != null) {
            short tmp = this.flags;
            for (Flag flag : flags) {
                if (flag == null) continue;
                tmp = (short)(tmp | flag.value());
            }
            this.flags = tmp;
        }
        return this;
    }

    public Message setTransientFlag(TransientFlag ... flags) {
        if (flags != null) {
            short tmp = this.transient_flags;
            for (TransientFlag flag : flags) {
                if (flag == null) continue;
                tmp = (short)(tmp | flag.value());
            }
            this.transient_flags = (byte)tmp;
        }
        return this;
    }

    public Message setFlag(short flag) {
        short tmp = this.flags;
        this.flags = tmp = (short)(tmp | flag);
        return this;
    }

    public Message setTransientFlag(short flag) {
        short tmp = this.transient_flags;
        tmp = (short)(tmp | flag);
        this.transient_flags = (byte)tmp;
        return this;
    }

    public short getFlags() {
        return this.flags;
    }

    public short getTransientFlags() {
        return this.transient_flags;
    }

    public Message clearFlag(Flag ... flags) {
        if (flags != null) {
            short tmp = this.flags;
            for (Flag flag : flags) {
                if (flag == null) continue;
                tmp = (short)(tmp & ~flag.value());
            }
            this.flags = tmp;
        }
        return this;
    }

    public Message clearTransientFlag(TransientFlag ... flags) {
        if (flags != null) {
            short tmp = this.transient_flags;
            for (TransientFlag flag : flags) {
                if (flag == null) continue;
                tmp = (short)(tmp & ~flag.value());
            }
            this.transient_flags = (byte)tmp;
        }
        return this;
    }

    public static boolean isFlagSet(short flags, Flag flag) {
        return flag != null && (flags & flag.value()) == flag.value();
    }

    public boolean isFlagSet(Flag flag) {
        return Message.isFlagSet(this.flags, flag);
    }

    public static boolean isTransientFlagSet(short flags, TransientFlag flag) {
        return flag != null && (flags & flag.value()) == flag.value();
    }

    public boolean isTransientFlagSet(TransientFlag flag) {
        return Message.isTransientFlagSet(this.transient_flags, flag);
    }

    public synchronized boolean setTransientFlagIfAbsent(TransientFlag flag) {
        if (this.isTransientFlagSet(flag)) {
            return false;
        }
        this.setTransientFlag(flag);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message putHeader(short id, Header hdr) {
        if (id < 0) {
            throw new IllegalArgumentException("An ID of " + id + " is invalid");
        }
        if (hdr != null) {
            hdr.setProtId(id);
        }
        Message message = this;
        synchronized (message) {
            Header[] resized_array = Headers.putHeader(this.headers, id, hdr, true);
            if (resized_array != null) {
                this.headers = resized_array;
            }
        }
        return this;
    }

    public <T extends Header> T getHeader(short id) {
        if (id <= 0) {
            throw new IllegalArgumentException("An ID of " + id + " is invalid. Add the protocol which calls getHeader() to jg-protocol-ids.xml");
        }
        return Headers.getHeader(this.headers, id);
    }

    public <T extends Header> T getHeader(short ... ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        return Headers.getHeader(this.headers, ids);
    }

    public Message copy() {
        return this.copy(true);
    }

    public Message copy(boolean copy_buffer) {
        return this.copy(copy_buffer, true);
    }

    public Message copy(boolean copy_buffer, boolean copy_headers) {
        Message retval = new Message(false);
        retval.dest = this.dest;
        retval.sender = this.sender;
        short tmp_flags = this.flags;
        byte tmp_tflags = this.transient_flags;
        retval.flags = tmp_flags;
        retval.transient_flags = tmp_tflags;
        if (copy_buffer && this.buf != null) {
            retval.setBuffer(this.buf, this.offset, this.length);
        }
        retval.headers = copy_headers && this.headers != null ? Headers.copy(this.headers) : Message.createHeaders(Util.DEFAULT_HEADERS);
        return retval;
    }

    public Message copy(boolean copy_buffer, short starting_id) {
        return this.copy(copy_buffer, starting_id, (short[])null);
    }

    public Message copy(boolean copy_buffer, short starting_id, short ... copy_only_ids) {
        Message retval = this.copy(copy_buffer, false);
        for (Map.Entry<Short, Header> entry : this.getHeaders().entrySet()) {
            short id = entry.getKey();
            if (id < starting_id && !Util.containsId(id, copy_only_ids)) continue;
            retval.putHeader(id, entry.getValue());
        }
        return retval;
    }

    public Message makeReply() {
        Message retval = new Message(this.sender);
        if (this.dest != null) {
            retval.setSrc(this.dest);
        }
        return retval;
    }

    public String toString() {
        return String.format("[%s to %s, %d bytes%s%s]", this.sender, this.dest == null ? "<all>" : this.dest, this.length, this.flags > 0 ? ", flags=" + Message.flagsToString(this.flags) : "", this.transient_flags > 0 ? ", transient_flags=" + Message.transientFlagsToString(this.transient_flags) : "");
    }

    public String printObjectHeaders() {
        return Headers.printObjectHeaders(this.headers);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        byte leading = 0;
        if (this.dest != null) {
            leading = Util.setFlag(leading, (byte)1);
        }
        if (this.sender != null) {
            leading = Util.setFlag(leading, (byte)2);
        }
        if (this.buf != null) {
            leading = Util.setFlag(leading, (byte)4);
        }
        out.write(leading);
        out.writeShort(this.flags);
        if (this.dest != null) {
            Util.writeAddress(this.dest, out);
        }
        if (this.sender != null) {
            Util.writeAddress(this.sender, out);
        }
        Header[] hdrs = this.headers;
        int size = Headers.size(hdrs);
        out.writeShort(size);
        if (size > 0) {
            for (Header hdr : hdrs) {
                if (hdr == null) break;
                out.writeShort(hdr.getProtId());
                Message.writeHeader(hdr, out);
            }
        }
        if (this.buf != null) {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
    }

    public void writeToNoAddrs(Address src, DataOutput out, short ... excluded_headers) throws IOException {
        boolean write_src_addr;
        byte leading = 0;
        boolean bl = write_src_addr = src == null || this.sender != null && !this.sender.equals(src);
        if (write_src_addr) {
            leading = Util.setFlag(leading, (byte)2);
        }
        if (this.buf != null) {
            leading = Util.setFlag(leading, (byte)4);
        }
        out.write(leading);
        out.writeShort(this.flags);
        if (write_src_addr) {
            Util.writeAddress(this.sender, out);
        }
        Header[] hdrs = this.headers;
        int size = Headers.size(hdrs, excluded_headers);
        out.writeShort(size);
        if (size > 0) {
            for (Header hdr : hdrs) {
                if (hdr == null) break;
                short id = hdr.getProtId();
                if (Util.containsId(id, excluded_headers)) continue;
                out.writeShort(id);
                Message.writeHeader(hdr, out);
            }
        }
        if (this.buf != null) {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        byte leading = in.readByte();
        this.flags = in.readShort();
        if (Util.isFlagSet(leading, (byte)1)) {
            this.dest = Util.readAddress(in);
        }
        if (Util.isFlagSet(leading, (byte)2)) {
            this.sender = Util.readAddress(in);
        }
        int len = in.readShort();
        this.headers = Message.createHeaders(len);
        for (int i = 0; i < len; ++i) {
            Header hdr;
            short id = in.readShort();
            this.headers[i] = hdr = Message.readHeader(in).setProtId(id);
        }
        if (Util.isFlagSet(leading, (byte)4)) {
            len = in.readInt();
            this.buf = new byte[len];
            in.readFully(this.buf, 0, len);
            this.length = len;
        }
    }

    public int readFromSkipPayload(ByteArrayDataInputStream in) throws IOException, ClassNotFoundException {
        byte leading = in.readByte();
        this.flags = in.readShort();
        if (Util.isFlagSet(leading, (byte)1)) {
            this.dest = Util.readAddress(in);
        }
        if (Util.isFlagSet(leading, (byte)2)) {
            this.sender = Util.readAddress(in);
        }
        int len = in.readShort();
        this.headers = Message.createHeaders(len);
        for (int i = 0; i < len; ++i) {
            Header hdr;
            short id = in.readShort();
            this.headers[i] = hdr = Message.readHeader(in).setProtId(id);
        }
        if (!Util.isFlagSet(leading, (byte)4)) {
            return -1;
        }
        this.length = in.readInt();
        return in.position();
    }

    public long size() {
        long retval = 3L;
        if (this.dest != null) {
            retval += (long)Util.size(this.dest);
        }
        if (this.sender != null) {
            retval += (long)Util.size(this.sender);
        }
        retval += 2L;
        retval += (long)Headers.marshalledSize(this.headers);
        if (this.buf != null) {
            retval += (long)(4 + this.length);
        }
        return retval;
    }

    public static String flagsToString(short flags) {
        Flag[] all_flags;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Flag flag : all_flags = Flag.values()) {
            if (!Message.isFlagSet(flags, flag)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            sb.append((Object)flag);
        }
        return sb.toString();
    }

    public static String transientFlagsToString(short flags) {
        TransientFlag[] all_flags;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (TransientFlag flag : all_flags = TransientFlag.values()) {
            if (!Message.isTransientFlagSet(flags, flag)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            sb.append((Object)flag);
        }
        return sb.toString();
    }

    protected static void writeHeader(Header hdr, DataOutput out) throws IOException {
        short magic_number = hdr.getMagicId();
        out.writeShort(magic_number);
        hdr.writeTo(out);
    }

    protected static Header readHeader(DataInput in) throws IOException, ClassNotFoundException {
        short magic_number = in.readShort();
        Header hdr = (Header)ClassConfigurator.create(magic_number);
        hdr.readFrom(in);
        return hdr;
    }

    protected static Header[] createHeaders(int size) {
        return size > 0 ? new Header[size] : new Header[3];
    }

    public static enum Flag {
        OOB(1),
        DONT_BUNDLE(2),
        NO_FC(4),
        NO_RELIABILITY(16),
        NO_TOTAL_ORDER(32),
        NO_RELAY(64),
        RSVP(128),
        RSVP_NB(256),
        INTERNAL(512),
        SKIP_BARRIER(1024);

        final short value;

        private Flag(short value) {
            this.value = value;
        }

        public short value() {
            return this.value;
        }
    }

    public static enum TransientFlag {
        OOB_DELIVERED(1),
        DONT_LOOPBACK(2);

        final short value;

        private TransientFlag(short flag) {
            this.value = flag;
        }

        public short value() {
            return this.value;
        }
    }
}

