/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.zip.CRC32;
import org.lsst.ccs.drivers.reb.sim.AutoCloseableReentrantLock;
import org.lsst.ccs.drivers.reb.sim.SequencerSimulation;

public class SequencerListener
implements SequencerSimulation.SubroutineListener,
SequencerSimulation.FunctionListener,
SequencerSimulation.WaveformListener,
SequencerSimulation.StateListener {
    private final CountMap subroutineCounts = new CountMap();
    private final CountMap functionCounts = new CountMap();
    private final CountMap subroutineReturns = new CountMap();
    private long accumulatedNanos;
    private final CRC32 checksum = new CRC32();
    private final AutoCloseableReentrantLock stateLock = new AutoCloseableReentrantLock();
    private final Condition stateChanged = this.stateLock.newCondition();
    private volatile SequencerSimulation.State currentState;

    @Override
    public void subroutineCalled(int address, int repetitions) {
        this.subroutineCounts.get(address).add(repetitions);
    }

    @Override
    public void subroutineReturned(int address) {
        this.subroutineReturns.get(address).increment();
    }

    @Override
    public void functionCalled(int function, boolean infiniteLoop, int repetitions) {
        this.functionCounts.get(function).add(repetitions);
    }

    public void waitForState(SequencerSimulation.State state, Duration timeout) throws InterruptedException, TimeoutException {
        try (AutoCloseableReentrantLock lock = this.stateLock.open();){
            do {
                if (this.currentState != state) continue;
                return;
            } while (this.stateChanged.await(timeout.toMillis(), TimeUnit.MILLISECONDS));
            throw new TimeoutException("Timed out waiting for state: " + (Object)((Object)state));
        }
    }

    @Override
    public void stateChanged(SequencerSimulation.State oldState, SequencerSimulation.State newState) {
        try (AutoCloseableReentrantLock lock = this.stateLock.open();){
            this.currentState = newState;
            this.stateChanged.signalAll();
        }
    }

    public Map<? extends Number, ? extends Number> getSubroutineCounts() {
        return this.subroutineCounts;
    }

    public Map<? extends Number, ? extends Number> getFunctionCounts() {
        return this.functionCounts;
    }

    public Map<? extends Number, ? extends Number> getSubroutineReturns() {
        return this.subroutineReturns;
    }

    @Override
    public void transition(int oldState, int newState, int nanos) {
        this.accumulatedNanos += (long)nanos;
        this.checksum.update(newState);
    }

    public long getAccumulatedNanos() {
        return this.accumulatedNanos;
    }

    public long getChecksum() {
        return this.checksum.getValue();
    }

    public void clear() {
        this.subroutineCounts.clear();
        this.functionCounts.clear();
        this.subroutineReturns.clear();
        this.accumulatedNanos = 0L;
        this.checksum.reset();
    }

    private static class CountMap
    extends ConcurrentHashMap<Integer, Count> {
        private CountMap() {
        }

        @Override
        public Count get(Object key) {
            Count result = (Count)super.get(key);
            if (result == null && key instanceof Integer) {
                result = new Count();
                this.put((Integer)key, result);
            }
            return result;
        }
    }

    private static class Count
    extends Number {
        private int count;

        private Count() {
        }

        void add(int n) {
            this.count += n;
        }

        void increment() {
            ++this.count;
        }

        public String toString() {
            return String.valueOf(this.count);
        }

        @Override
        public int intValue() {
            return this.count;
        }

        @Override
        public long longValue() {
            return this.count;
        }

        @Override
        public float floatValue() {
            return this.count;
        }

        @Override
        public double doubleValue() {
            return this.count;
        }
    }
}

