/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public final class CanOpenErrorsTable {
    private static final Logger FCSLOG = Logger.getLogger(CanOpenErrorsTable.class.getName());
    private static final String DEVICE_ERROR_CODES_FILENAME = "/maxonMotorDeviceErrors.properties";
    private static final String ERROR_REGISTER_CODES_FILENAME = "/errorRegister.properties";
    private static final String CANOPEN_SDO_ERROR_CODES_FILENAME = "/canopenSDOErrors.properties";
    private static final Map<String, Map<Integer, String>> tables = new HashMap<String, Map<Integer, String>>();

    private CanOpenErrorsTable() {
    }

    public static void loadCanOpenErrorTables() {
        for (Map.Entry<String, Map<Integer, String>> entry : tables.entrySet()) {
            String tableName = entry.getKey();
            InputStream is = CanOpenErrorsTable.class.getResourceAsStream(tableName);
            if (is == null) {
                throw new RuntimeException("Could not find " + tableName + " properties file in resources.");
            }
            try {
                Properties props = new Properties();
                props.load(is);
                for (String name : props.stringPropertyNames()) {
                    entry.getValue().put(Integer.parseInt(name, 16), props.getProperty(name));
                }
                FCSLOG.finer(() -> tableName + " size : " + ((Map)entry.getValue()).size());
            }
            catch (IOException ex) {
                throw new RuntimeException("could not load " + tableName + " from local resources", ex);
            }
        }
    }

    public static String getDeviceErrorNameByCode(int aCode) {
        return CanOpenErrorsTable.getErrorInternal(aCode, DEVICE_ERROR_CODES_FILENAME);
    }

    public static String getErrorRegisterNameByCode(int aCode) {
        return CanOpenErrorsTable.getErrorInternal(aCode, ERROR_REGISTER_CODES_FILENAME);
    }

    public static String getCanopenSDOErrorNameByCode(int aCode) {
        return CanOpenErrorsTable.getErrorInternal(aCode, CANOPEN_SDO_ERROR_CODES_FILENAME);
    }

    private static String getErrorInternal(int aCode, String fileName) {
        String commErrorName = tables.get(fileName).get(aCode);
        if (commErrorName == null) {
            commErrorName = Integer.toHexString(aCode) + "= unknown in " + fileName;
        }
        return commErrorName;
    }

    static {
        tables.put(DEVICE_ERROR_CODES_FILENAME, new HashMap());
        tables.put(ERROR_REGISTER_CODES_FILENAME, new HashMap());
        tables.put(CANOPEN_SDO_ERROR_CODES_FILENAME, new HashMap());
    }
}

