/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.Entity;
import DDS.StatusCondition;
import org.opensplice.dds.dcps.EntityImpl;
import org.opensplice.dds.dcps.ReportStack;
import org.opensplice.dds.dcps.StatusConditionBase;

public class StatusConditionImpl
extends StatusConditionBase
implements StatusCondition {
    private static final long serialVersionUID = -4875040149672344445L;
    private int enabledStatuses = -1;
    private EntityImpl entity = null;

    protected int init(EntityImpl entity) {
        int result = 0;
        assert (entity != null);
        long uEntity = entity.get_user_object();
        if (uEntity != 0L) {
            long uCondition = this.jniStatusConditionNew(uEntity);
            if (uCondition != 0L) {
                this.set_user_object(uCondition);
                this.entity = entity;
                this.setDomainId(entity.getDomainId());
                result = 0;
            } else {
                result = 1;
            }
        } else {
            result = 9;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int deinit() {
        int result = 0;
        StatusConditionImpl statusConditionImpl = this;
        synchronized (statusConditionImpl) {
            long uCondition = this.get_user_object();
            if (uCondition != 0L) {
                this.entity = null;
                result = super.deinit();
                if (result == 0) {
                    result = this.jniStatusConditionFree(uCondition);
                }
            } else {
                result = 9;
            }
        }
        return result;
    }

    @Override
    public int get_enabled_statuses() {
        return this.enabledStatuses;
    }

    @Override
    public int set_enabled_statuses(int mask) {
        long uStatusCondition = 0L;
        int result = 0;
        ReportStack.start();
        uStatusCondition = this.get_user_object();
        if (uStatusCondition != 0L) {
            result = this.jniSetEnabledStatuses(uStatusCondition, mask);
            if (result == 0) {
                this.enabledStatuses = mask;
            }
        } else {
            result = 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public Entity get_entity() {
        return this.entity;
    }

    @Override
    public boolean get_trigger_value() {
        long uStatusCondition = 0L;
        boolean result = false;
        ReportStack.start();
        uStatusCondition = this.get_user_object();
        if (uStatusCondition != 0L) {
            result = this.jniGetTriggerValue(uStatusCondition);
        }
        ReportStack.flush(this, false);
        return result;
    }

    private native long jniStatusConditionNew(long var1);

    private native int jniStatusConditionFree(long var1);

    private native int jniSetEnabledStatuses(long var1, int var3);

    private native boolean jniGetTriggerValue(long var1);
}

