/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.lambda.Cpfe1000;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class CpfeDevice
extends Device {
    public static final int CHAN_STATUS = 0;
    public static final int CHAN_TEMPERATURE = 1;
    public static final int CHAN_VOLTAGE = 2;
    public static final int CHAN_CURRENT = 3;
    public static final int NUM_CHANS = 4;
    private String devcId;
    private int address = 160;
    private static final Logger LOG = Logger.getLogger(CpfeDevice.class.getName());
    private final Cpfe1000 cpfe = new Cpfe1000();
    private boolean initError = false;

    protected void initDevice() {
        if (this.devcId == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"devcId", (String)"is missing");
        }
        this.fullName = "CPFE1000 (" + this.devcId + ":" + this.address + ")";
    }

    protected void initialize() {
        block2: {
            try {
                this.cpfe.open(this.devcId, this.address);
                this.initSensors();
                LOG.log(Level.INFO, "Connected to {0}", this.fullName);
                this.initError = false;
                this.setOnline(true);
            }
            catch (DriverException e) {
                if (this.initError) break block2;
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
        }
    }

    protected void close() {
        try {
            this.cpfe.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int hwChan = ch.getHwChan();
        if (hwChan < 0 || hwChan >= 4) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"hwchan", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected double readChannel(Channel ch) {
        double value = Double.NaN;
        try {
            switch (ch.getHwChan()) {
                case 0: {
                    value = this.cpfe.readStatus();
                    break;
                }
                case 1: {
                    value = this.cpfe.readTemperature();
                    break;
                }
                case 2: {
                    value = this.cpfe.readVoltage();
                    break;
                }
                case 3: {
                    value = this.cpfe.readCurrent();
                }
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error reading CPFE1000 data: {0}", e);
            this.setOnline(false);
        }
        return value;
    }
}

