/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.shutter.StateMachine;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SynchronousChannel;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class BrakePowerMonitor
implements HasLifecycle,
StatusMessageListener,
AlertListener {
    private static final Logger LOG = Logger.getLogger(BrakePowerMonitor.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    private volatile Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile StateMachine machine;
    private volatile AgentMessagingLayer aml;
    @ConfigurationParameter(description="The key of the brake voltage value in the KeyValueDataList.", isFinal=true, units="unitless")
    private volatile String brakeVoltageKey = "PDU_24VD/Shtr_Brakes_V";
    @ConfigurationParameter(description="Brake power voltage must be at least this to be considered 'on'.", isFinal=true, units="V")
    private volatile double powerOnThreshold = 23.0;
    private final BlockingQueue<Boolean> eventQueue = new LinkedBlockingQueue<Boolean>();
    private final Scheduler eventScheduler = new Scheduler("brakePower", 1, new ThreadGroup("Brake power monitoring"));

    BrakePowerMonitor() {
    }

    public void init() {
        ((AlertService)this.subsys.getAgentService(AlertService.class)).addListener((AlertListener)this);
        ((AlertService)this.subsys.getAgentService(AlertService.class)).startStatusAlertListening(a -> true);
    }

    public void postStart() {
        this.aml = this.subsys.getMessagingAccess();
        this.aml.addStatusMessageListener((StatusMessageListener)this, msg -> msg.getOriginAgentInfo().hasAgentProperty("quadBoxAgent") && msg instanceof StatusSubsystemData && ((StatusSubsystemData)msg).getObject() instanceof KeyValueDataList);
        this.eventScheduler.schedule(this::schedulerLoop, 0L, TimeUnit.SECONDS);
    }

    public void postShutdown() {
        this.eventScheduler.shutdownNow();
        this.aml.removeStatusMessageListener((StatusMessageListener)this);
        ((AlertService)this.subsys.getAgentService(AlertService.class)).removeListener((AlertListener)this);
    }

    public void onStatusMessage(StatusMessage rawMsg) {
        List kvdList = ((KeyValueDataList)((StatusSubsystemData)rawMsg).getObject()).getListOfKeyValueData();
        Optional<KeyValueData> kvd = kvdList.stream().filter(k -> k.getKey().equals(this.brakeVoltageKey)).findFirst();
        if (kvd.isPresent()) {
            double voltage = (Double)kvd.get().getValue();
            this.sendPowerEvent(voltage >= this.powerOnThreshold);
        }
    }

    public void onAlert(AlertEvent event) {
        switch (event.getType()) {
            case AGENT_CONNECTION: {
                break;
            }
            case AGENT_DISCONNECTION: {
                this.sendPowerEvent(false);
                break;
            }
            case ALERT_CLEARED: {
                List clearedIds = event.getClearedIds();
                this.sendPowerEvent(clearedIds.contains(this.brakeVoltageKey));
                break;
            }
            case ALERT_RAISED: {
                Alert alrt = event.getAlert();
                if (!alrt.getAlertId().equals(this.brakeVoltageKey)) break;
                this.sendPowerEvent(event.getLevel() == AlertState.NOMINAL);
            }
        }
    }

    private void sendPowerEvent(boolean powerIsOn) {
        this.eventQueue.add(powerIsOn);
    }

    private void schedulerLoop() {
        LOG.info("Starting the brake power monitoring task.");
        SynchronousChannel<EventReply> replyChan = new SynchronousChannel<EventReply>();
        block5: while (true) {
            try {
                while (true) {
                    boolean powerIsOn = this.eventQueue.take();
                    try {
                        this.machine.brakePowerChange(replyChan, powerIsOn);
                        EventReply eventReply = (EventReply)replyChan.read();
                        continue block5;
                    }
                    catch (InterruptedException exc) {
                        throw exc;
                    }
                    catch (Exception exc) {
                        LOG.log(Level.SEVERE, "Exception in brake power monitoring task.", exc);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException exc) {
                LOG.info("Normal termination of the brake power monitoring task.");
                return;
            }
        }
    }
}

