/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.protocol.io;

import com.thoughtworks.xstream.core.util.CustomObjectOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.indilib.i4j.protocol.INDIProtocol;
import org.indilib.i4j.protocol.api.INDIOutputStream;
import org.indilib.i4j.protocol.url.INDIURLStreamHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INDIOutputStreamImpl
extends OutputStream
implements INDIOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(INDIOutputStreamImpl.class);
    private CustomObjectOutputStream out;

    protected INDIOutputStreamImpl(CustomObjectOutputStream out) throws IOException {
        this.out = out;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void write(int b) throws IOException {
        throw new IOException("not supported method");
    }

    @Override
    public synchronized void writeObject(INDIProtocol<?> element) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("sending indi object " + element);
        }
        this.out.writeObject(element);
        this.out.flush();
    }

    static {
        INDIURLStreamHandlerFactory.init();
    }
}

