/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;

public class CanOpenEPOSWithPDO
extends CanOpenEPOS {
    protected int cobid1 = 384;
    protected int cobid2 = 640;
    private long pdo1 = 0L;
    private long pdo2 = 0L;

    public void setPdo1(long pdo1) {
        this.pdo1 = pdo1;
    }

    public void setPdo2(long pdo2) {
        this.pdo2 = pdo2;
    }

    public long getPdo1() {
        return this.pdo1;
    }

    public long getPdo2() {
        return this.pdo2;
    }

    public int getCobid1() {
        return this.cobid1;
    }

    public int getCobid2() {
        return this.cobid2;
    }

    @Override
    public void init() {
        super.init();
        super.build();
        this.cobid1 = this.nodeID + 384;
        this.cobid2 = this.nodeID + 640;
    }

    @Override
    public void doInitializePDOs() throws DriverException {
        this.tcpProxy.addReceivedPDO(this.cobid1);
        this.tcpProxy.addReceivedPDO(this.cobid2);
    }

    @Override
    public void updateFromPDO(PDOData pdo) {
        FCSLOG.finest(this.name + " updatingFromPDO = " + pdo);
        boolean updated = false;
        if (pdo.getPDOs().containsKey(this.cobid1)) {
            this.pdo1 = (Long)pdo.getPDOs().get(this.cobid1);
            updated = true;
            FCSLOG.finer(this.name + " updatingFromPDO1 = " + this.pdo1 + " binary:" + Long.toBinaryString(this.pdo1));
            this.statusWord = CanOpenEPOSWithPDO.extractStatusWord(this.pdo1);
            this.averageCurrent = (short)CanOpenEPOSWithPDO.extractAverageCurrent(this.pdo1);
            this.position = CanOpenEPOSWithPDO.extractPosition(this.pdo1);
            this.updateEposState(this.statusWord);
            FCSLOG.finer(this.name + " position = " + this.position + " pdo1 =  binary:" + Long.toBinaryString(this.pdo1));
        }
        if (pdo.getPDOs().containsKey(this.cobid2)) {
            this.pdo2 = (Long)pdo.getPDOs().get(this.cobid2);
            updated = true;
            FCSLOG.finer(this.name + " updatingFromPDO2 = " + this.pdo2 + " binary:" + Long.toBinaryString(this.pdo2));
            this.current = (short)CanOpenEPOSWithPDO.extractCurrent(this.pdo2);
            this.followingError = (short)CanOpenEPOSWithPDO.extractFollowingError(this.pdo2);
            this.velocity = CanOpenEPOSWithPDO.extractAverageVelocity(this.pdo2);
        }
        if (updated) {
            this.publishData();
        }
    }

    public static int extractStatusWord(long pdo) {
        return (int)pdo & 0xFFFF;
    }

    public static int extractAverageCurrent(long pdo) {
        return (int)(pdo >> 16) & 0xFFFF;
    }

    public static int extractPosition(long pdo) {
        return (int)(pdo >> 32) & 0xFFFFFFFF;
    }

    public static int extractCurrent(long pdo) {
        return (int)pdo & 0xFFFF;
    }

    public static int extractFollowingError(long pdo) {
        return (int)(pdo >> 16) & 0xFFFF;
    }

    public static int extractAverageVelocity(long pdo) {
        return (int)(pdo >> 32) & 0xFFFFFFFF;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Print values updated by PDOs to debug and test")
    public String printValuesUpdatedByPDOs() {
        StringBuilder sb = new StringBuilder("=> pdo1 value = ");
        sb.append(this.pdo1);
        sb.append(" / pdo1 = 0x");
        sb.append(Long.toHexString(this.pdo1));
        sb.append(" / status word = 0x");
        sb.append(Long.toHexString(this.statusWord));
        sb.append("\n status word = 0b");
        sb.append(Long.toBinaryString(this.statusWord));
        sb.append("\n average current = ");
        sb.append(this.averageCurrent);
        sb.append(" / average current = 0x");
        sb.append(Long.toHexString(this.averageCurrent));
        sb.append("\n position = ");
        sb.append(this.position);
        sb.append(" / position = 0x");
        sb.append(Long.toHexString(this.position));
        sb.append("\n => pdo2 value = ");
        sb.append(this.pdo2);
        sb.append(" / pdo2 = 0x");
        sb.append(Long.toHexString(this.pdo2));
        sb.append("\n current = ");
        sb.append(this.current);
        sb.append(" / current = 0x");
        sb.append(Long.toHexString(this.current));
        sb.append("\n followingError = ");
        sb.append(this.followingError);
        sb.append(" / followingError = 0x");
        sb.append(Long.toHexString(this.followingError));
        sb.append(this.followingError);
        sb.append("\n Velocity = ");
        sb.append(this.velocity);
        sb.append(" / velocity = 0x");
        sb.append("\n ControlWord = ");
        sb.append(this.controlWord);
        sb.append(" / controlWord = 0x");
        sb.append(Long.toHexString(this.controlWord));
        return sb.toString();
    }
}

