/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.wattsup;

import java.io.PrintStream;
import jline.console.ConsoleReader;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class TalkWattsUp {
    private static final PrintStream out = System.out;
    private final Thread readW = new Thread(new Reader());
    private final Ascii asc = new Ascii();
    private int nRead = 0;
    private int nByte = 0;
    private boolean open;

    public static void main(String[] args) throws Exception {
        try {
            String serial = args.length >= 1 ? args[0] : null;
            new TalkWattsUp().run(serial);
        }
        catch (NumberFormatException e) {
            out.println("Invalid device index");
        }
        System.exit(0);
    }

    public void run(String serial) throws Exception {
        String line;
        this.asc.openSerial(serial, 115200, 0);
        this.open = true;
        this.readW.setDaemon(true);
        this.readW.start();
        ConsoleReader readC = new ConsoleReader();
        while ((line = readC.readLine("")) != null) {
            if (line.equals("")) {
                out.format("#reads: %s; #bytes: %s\n", this.nRead, this.nByte);
                continue;
            }
            this.asc.writeBytes(line.getBytes());
        }
        this.open = false;
        this.asc.close();
    }

    private class Reader
    implements Runnable {
        byte[] data = new byte[1024];

        private Reader() {
        }

        @Override
        public void run() {
            while (true) {
                int leng = 0;
                try {
                    leng = TalkWattsUp.this.asc.readBytes(this.data, 0);
                }
                catch (DriverTimeoutException e) {
                    continue;
                }
                catch (DriverException e) {
                    if (!TalkWattsUp.this.open) break;
                    out.println((Object)e);
                    break;
                }
                out.write(this.data, 0, leng);
                TalkWattsUp.this.nRead++;
                TalkWattsUp.this.nByte = TalkWattsUp.this.nByte + leng;
            }
        }
    }
}

