/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.cluster.monitor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandMessage;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandReply;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessagePreProcessor;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.InfluxDbClientService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.cluster.monitor.Accumulate;
import org.lsst.ccs.subsystem.imagehandling.data.ImageHeaderKeywords;
import org.lsst.ccs.utilities.scheduler.Scheduler;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class BusTrafficMonitor
implements HasLifecycle,
AgentPresenceListener {
    private static final Object counterLock = new Object();
    private static final Logger LOG_INFLUX = Logger.getLogger(BusTrafficMonitor.class.getName() + ".influx");
    private static final Logger LOG_MSG = Logger.getLogger(BusTrafficMonitor.class.getName() + ".messages");
    private static final Logger LOG_APL = Logger.getLogger(BusTrafficMonitor.class.getName() + ".apl");
    private static final Alert CLUSTER_SPLIT_ALERT = new Alert("clusterSplit", "Alert raised when the CCS cluster splits");
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    InfluxDbClientService influxDbClientService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    private static final HashMap<UUID, CommandMsg> commands = new HashMap();
    private static BlockingQueue<Runnable> statusQueue = null;
    private static BlockingQueue<Runnable> commandQueue = null;
    private static BlockingQueue<Runnable> logQueue = null;
    private Thread statusThread;
    private Thread commandThread;
    private Thread logThread;
    private final CommandBusCounterListener commandBusListener = new CommandBusCounterListener();
    private final StatusBusCounterListener statusBusListener = new StatusBusCounterListener();
    private final LogBusCounterListener logBusListener = new LogBusCounterListener();
    private final Scheduler messageScheduler = new Scheduler("Message processing scheduler", 6);
    private final ClearAlertHandler alwaysClear = new ClearAlertHandler(){

        public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState state) {
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
    };
    private Map<String, CCSTimeStamp> disconnectedAgents = new ConcurrentHashMap<String, CCSTimeStamp>();
    private static Map<Tags, Integer> agentCountersMap = new ConcurrentHashMap<Tags, Integer>();
    private static Map<Tags, Map<String, Accumulate>> tagsAccumMap = new ConcurrentHashMap<Tags, Map<String, Accumulate>>();

    public void build() {
        AgentPeriodicTask resetCounterAndPublish = new AgentPeriodicTask("busTrafficStatsUpdate", () -> this.resetCounterAndPublish()).withPeriod(Duration.ofSeconds(60L));
        ((AgentPeriodicTaskService)this.agent.getAgentService(AgentPeriodicTaskService.class)).scheduleAgentPeriodicTask(resetCounterAndPublish);
        this.agent.getMessagingAccess().addBusMessagePreProcessor((BusMessagePreProcessor)this.commandBusListener);
        this.agent.getMessagingAccess().addBusMessagePreProcessor((BusMessagePreProcessor)this.logBusListener);
        this.agent.getMessagingAccess().addBusMessagePreProcessor((BusMessagePreProcessor)this.statusBusListener);
        this.alertService.registerAlert(CLUSTER_SPLIT_ALERT, this.alwaysClear);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCounters() {
        Thread oldStatusThread = this.statusThread;
        Thread oldCommandThread = this.commandThread;
        Thread oldLogThread = this.logThread;
        Object object = counterLock;
        synchronized (object) {
            agentCountersMap = new ConcurrentHashMap<Tags, Integer>();
            tagsAccumMap = new ConcurrentHashMap<Tags, Map<String, Accumulate>>();
            if (statusQueue != null) {
                statusQueue.add(new DoneWork());
                commandQueue.add(new DoneWork());
                logQueue.add(new DoneWork());
            }
            statusQueue = new LinkedBlockingQueue<Runnable>();
            commandQueue = new LinkedBlockingQueue<Runnable>();
            logQueue = new LinkedBlockingQueue<Runnable>();
            this.statusThread = new MyQueueWorker(statusQueue);
            this.commandThread = new MyQueueWorker(commandQueue);
            this.logThread = new MyQueueWorker(logQueue);
            this.statusThread.start();
            this.commandThread.start();
            this.logThread.start();
        }
        try {
            if (oldStatusThread != null) {
                oldStatusThread.join();
            }
            if (oldCommandThread != null) {
                oldCommandThread.join();
            }
            if (oldLogThread != null) {
                oldLogThread.join();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public void postInit() {
        this.resetCounters();
    }

    public void start() {
        this.resetCounters();
        this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    public void shutdown() {
        this.agent.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
    }

    public void connecting(AgentInfo ... agents) {
        LOG_APL.log(Level.FINE, "Connecting Agents: {0}", Arrays.asList(agents));
    }

    public void connected(AgentInfo ... agents) {
        LOG_APL.log(Level.FINE, "Connected Agents: {0}", Arrays.asList(agents));
        HashMap<String, Duration> reconnected = new HashMap<String, Duration>();
        for (AgentInfo agent : agents) {
            String agentName = agent.getName();
            CCSTimeStamp ts = this.disconnectedAgents.remove(agentName);
            if (ts == null) continue;
            reconnected.put(agentName, Duration.between(ts.getUTCInstant(), CCSTimeStamp.currentTime().getUTCInstant()));
        }
        if (!reconnected.isEmpty()) {
            String msg = "Reconnected agents: ";
            for (String agent : reconnected.keySet()) {
                msg = msg + agent + " (" + ((Duration)reconnected.get(agent)).getSeconds() + "s) ";
            }
            LOG_APL.log(Level.WARNING, msg);
            if (this.disconnectedAgents.isEmpty()) {
                this.alertService.raiseAlert(CLUSTER_SPLIT_ALERT, AlertState.NOMINAL, "All missing agents have rejoined the cluster.");
            } else {
                this.alertService.raiseAlert(CLUSTER_SPLIT_ALERT, AlertState.WARNING, "The following agents are still missing: " + this.disconnectedAgents.keySet());
            }
        }
    }

    public void disconnected(AgentInfo ... agents) {
        LOG_APL.log(agents.length < 2 ? Level.FINE : Level.WARNING, "Disconnecting Agent: {0}", Arrays.asList(agents));
        if (agents.length >= 2) {
            this.alertService.raiseAlert(CLUSTER_SPLIT_ALERT, AlertState.WARNING, "These agents left the cluster: " + Arrays.asList(agents));
            CCSTimeStamp now = CCSTimeStamp.currentTime();
            for (AgentInfo agent : agents) {
                this.disconnectedAgents.put(agent.getName(), now);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void resetCounterAndPublish() {
        Map<Tags, Map<String, Accumulate>> agentTimeAccumulatorsMapOld;
        Map<Tags, Integer> agentCountersMapOld;
        Object object = counterLock;
        synchronized (object) {
            agentCountersMapOld = agentCountersMap;
            agentTimeAccumulatorsMapOld = tagsAccumMap;
        }
        this.resetCounters();
        if (this.influxDbClientService.isEnabled()) {
            ConcurrentHashMap.KeySetView allTags = ConcurrentHashMap.newKeySet();
            allTags.addAll(agentCountersMapOld.keySet());
            allTags.addAll(agentTimeAccumulatorsMapOld.keySet());
            BatchPoints bp = this.influxDbClientService.createBatchPoints();
            long time = System.currentTimeMillis();
            for (Tags tag : allTags) {
                void var9_9;
                Point.Builder builder = Point.measurement((String)"cluster_metrics").time(time, TimeUnit.MILLISECONDS);
                Integer counter = agentCountersMapOld.get(tag);
                if (counter != null) {
                    Point.Builder builder2 = builder.addField("traffic", (Number)counter);
                }
                Map<String, Accumulate> accumMap = agentTimeAccumulatorsMapOld.get(tag);
                for (String key : accumMap.keySet()) {
                    Accumulate accum = accumMap.get(key);
                    if (accum.getCounts() <= 0) continue;
                    Point.Builder builder3 = var9_9.addField(key + "_avg", accum.getAverageValue()).addField(key + "_max", accum.getMaxValue()).addField(key + "_min", accum.getMinValue()).addField(key + "_tot", accum.getTotalValue());
                }
                if (!var9_9.hasFields()) continue;
                AgentInfo.AgentType agentType = tag.agentInfo.getType();
                String agentName = tag.agentInfo.getName();
                Point point = var9_9.tag("bus", tag.bus.name()).tag("agent", agentName).tag("host", tag.agentInfo.getAgentProperty("org.lsst.ccs.agent.hostname", "")).tag("user", tag.agentInfo.getAgentProperty("org.lsst.ccs.agent.username", "")).tag("msgType", tag.messageType).tag("type", agentType.name()).tag(this.influxDbClientService.getGlobalTags()).build();
                LOG_INFLUX.fine("Writing to influxDb " + point);
                bp.point(point);
            }
            HashMap<String, Integer> typeCount = new HashMap<String, Integer>();
            for (AgentInfo agentInfo : this.agent.getMessagingAccess().getAgentPresenceManager().listConnectedAgents()) {
                Integer currentCount;
                AgentInfo.AgentType type = agentInfo.getType();
                String typeStr = type.name();
                if (type == AgentInfo.AgentType.CONSOLE && !agentInfo.isGraphicalConsole()) {
                    typeStr = agentInfo.isScriptingConsole() ? "script" : "shell";
                }
                Integer n = currentCount = typeCount.getOrDefault(typeStr, 0);
                currentCount = currentCount + 1;
                typeCount.put(typeStr, currentCount);
            }
            for (Map.Entry entry : typeCount.entrySet()) {
                Point.Builder pointBuilder = Point.measurement((String)"cluster_metrics").time(time, TimeUnit.MILLISECONDS);
                if (!(pointBuilder = pointBuilder.addField("agent_count", (Number)entry.getValue())).hasFields()) continue;
                Point point = pointBuilder.tag("type", (String)entry.getKey()).tag(this.influxDbClientService.getGlobalTags()).build();
                bp.point(point);
            }
            if (!bp.getPoints().isEmpty()) {
                this.influxDbClientService.write(bp);
            }
        }
    }

    private static void incrementAgentCounter(Tags tags) {
        Integer agentCounter = agentCountersMap.get(tags);
        if (agentCounter == null) {
            agentCounter = 0;
        }
        agentCounter = agentCounter + 1;
        agentCountersMap.put(tags, agentCounter);
    }

    private static void incrementAgentKeyAccumulator(Tags tags, String key, double value) {
        Accumulate accum;
        Map<String, Accumulate> keyAccumMap = tagsAccumMap.get(tags);
        if (keyAccumMap == null) {
            keyAccumMap = new HashMap<String, Accumulate>();
            tagsAccumMap.put(tags, keyAccumMap);
        }
        if ((accum = keyAccumMap.get(key)) == null) {
            accum = new Accumulate();
            keyAccumMap.put(key, accum);
        }
        accum.accumulate(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processBusMessage(Bus bus, BusMessage msg, CCSTimeStamp received) {
        AgentInfo agentInfo = msg.getOriginAgentInfo();
        Tags tags = new Tags(bus, agentInfo, msg);
        MsgInfo msgInfo = new MsgInfo(msg, received);
        Object object = counterLock;
        synchronized (object) {
            BusTrafficMonitor.incrementAgentCounter(tags);
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "process_out", msgInfo.getOutboundProcessingTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "creation_to_queue_out", msgInfo.getCreationToQueueTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "queue_out", msgInfo.getOutgoingQueueTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "queue_out_to_serialization", msgInfo.getQueueToSerializationTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "serialization", msgInfo.getSerializationTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "transfer", msgInfo.getNetworkTransferTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "deserialization", msgInfo.getDeserializationTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "deserialization_to_queue_in", msgInfo.getDeserializationToQueueTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "queue_in", msgInfo.getIncomingQueueTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "process_in", msgInfo.getQueueToReceiveTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "transfer_total", msgInfo.getTotalTransferTime());
            BusTrafficMonitor.incrementAgentKeyAccumulator(tags, "size", msgInfo.getSize());
        }
        if (msg instanceof StatusMessage) {
            if (!(msg instanceof StatusHeartBeat)) {
                ImageHeaderKeywords keywords;
                Map headerMap;
                StatusSubsystemData ssd;
                Level logLevel = msgInfo.getTotalTransferTime() > 50L ? Level.INFO : Level.FINE;
                LOG_MSG.log(logLevel, "{0}\n{1}", new Object[]{BusTrafficMonitor.getMessageInfoStr(msgInfo), BusTrafficMonitor.getMessageTimingInformation(msgInfo)});
                LOG_MSG.log(Level.FINER, "{0}", msg);
                if (msg instanceof StatusSubsystemData && "ImageHeaderKeywords".equals((ssd = (StatusSubsystemData)msg).getDataKey()) && (headerMap = (keywords = (ImageHeaderKeywords)((KeyValueData)ssd.getObject()).getValue()).getKeywords()).containsKey("darkTime")) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("DarkTime msg : \n");
                    sb.append(BusTrafficMonitor.getMessageTimingInformation(msgInfo));
                    LOG_MSG.log(Level.INFO, "{0}", sb.toString());
                }
            }
        } else if (msg instanceof CommandMessage) {
            CommandMsg existingMsg;
            CommandMessage cmdMsg = (CommandMessage)msg;
            UUID corrId = cmdMsg.getCorrelationId();
            if (cmdMsg instanceof CommandRequest) {
                commands.put(corrId, new CommandMsg(msgInfo));
            } else if (msg instanceof CommandAck) {
                CommandMsg existingMsg2 = commands.get(corrId);
                if (existingMsg2 != null) {
                    existingMsg2.setAck(msgInfo);
                }
            } else if ((msg instanceof CommandNack || msg instanceof CommandResult) && (existingMsg = commands.remove(corrId)) != null) {
                existingMsg.logCommandMsg(msgInfo);
            }
        }
    }

    public static double sizeOf(Serializable object) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteOutputStream);){
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (IOException ieo) {
            return 0.0;
        }
        return (double)byteOutputStream.toByteArray().length / 1000.0;
    }

    private static String getMessageInfoStr(MsgInfo msgInfo) {
        BusMessage msg = msgInfo.msg;
        if (msg instanceof CommandRequest) {
            CommandRequest request = (CommandRequest)msg;
            return String.format("Command Request to " + request.getDestination() + " from " + request.getOriginAgentInfo().getName() + ": " + request.getBasicCommand().getCommand() + " (" + msgInfo.getTotalTransferTime() + " ms, " + msgInfo.getSize() + " Kb)", new Object[0]);
        }
        if (msg instanceof CommandReply) {
            String header = "unknown";
            if (msg instanceof CommandAck) {
                header = "Command Ack";
            } else if (msg instanceof CommandNack) {
                header = "Command Nack";
            } else if (msg instanceof CommandResult) {
                header = "Command Result";
            }
            return String.format(header + ": (" + msgInfo.getTotalTransferTime() + " ms, " + msgInfo.getSize() + " Kb)", new Object[0]);
        }
        if (msg instanceof StatusMessage) {
            return String.format("Status " + msg.getClass().getSimpleName() + " from " + msg.getOriginAgentInfo().getName() + ": (" + msgInfo.getTotalTransferTime() + " ms, " + msgInfo.getSize() + " Kb)", new Object[0]);
        }
        return "";
    }

    private static String getMessageTimingInformation(MsgInfo msgInfo) {
        StringBuilder sb = new StringBuilder("Message timing (ms)\n\tTotal transfer time ");
        sb.append(msgInfo.getTotalTransferTime()).append("\n\tOutgoing Processing ");
        sb.append(msgInfo.getOutboundProcessingTime()).append("\n\t\tCreation to queue ");
        sb.append(msgInfo.getCreationToQueueTime()).append("\n\t\tOutgoing queue ");
        sb.append(msgInfo.getOutgoingQueueTime()).append("\n\t\tOutgoing queue to serialization ");
        sb.append(msgInfo.getQueueToSerializationTime()).append("\n\t\tSerialization ");
        sb.append(msgInfo.getSerializationTime()).append("\n\tNetwork Transfer ");
        sb.append(msgInfo.getNetworkTransferTime()).append("\n\tIncoming Processing ");
        sb.append(msgInfo.getInboundProcessingTime()).append("\n\t\tDeserialization ");
        sb.append(msgInfo.getDeserializationTime()).append("\n\t\tDeserialization to incoming queue ");
        sb.append(msgInfo.getDeserializationToQueueTime()).append("\n\t\tIncoming queue ");
        sb.append(msgInfo.getIncomingQueueTime()).append("\n\t\tIncoming queue to processing ");
        sb.append(msgInfo.getQueueToReceiveTime()).append("\n");
        return sb.toString();
    }

    private static class MsgInfo {
        private final BusMessage msg;
        private final long totalTransferTime;
        private final long networkTransferTime;
        private final long outboundProcessingTime;
        private final long inboundProcessingTime;
        private final long serializationTime;
        private final long deserializationTime;
        private final long outgoingQueueTime;
        private final long incomingQueueTime;
        private final long creationToQueueTime;
        private final long deserializationToQueueTime;
        private final long queueToSerializationTime;
        private final long queueToReceiveTime;
        private final CCSTimeStamp received;
        private double size;

        MsgInfo(BusMessage msg, CCSTimeStamp received) {
            this.msg = msg;
            this.received = received;
            this.totalTransferTime = Duration.between(msg.getCCSTimeStamp().getUTCInstant(), received.getUTCInstant()).toMillis();
            this.networkTransferTime = msg.getTransferDuration() != null ? msg.getTransferDuration().toMillis() : 0L;
            this.outboundProcessingTime = msg.getSerializationTime() != null ? Duration.between(msg.getCCSTimeStamp().getUTCInstant(), msg.getSerializationTime().getUTCInstant()).toMillis() : 0L;
            this.inboundProcessingTime = msg.getDoneDeSerializationTime() != null ? Duration.between(msg.getDoneDeSerializationTime().getUTCInstant(), received.getUTCInstant()).toMillis() : -1L;
            this.serializationTime = msg.getSerializationDuration() != null ? msg.getSerializationDuration().toMillis() : -1L;
            this.deserializationTime = msg.getDeserializationDuration() != null ? msg.getDeserializationDuration().toMillis() : -1L;
            this.outgoingQueueTime = msg.getOutgoingQueueInTimeStamp() != null && msg.getOutgoingQueueOutTimeStamp() != null ? Duration.between(msg.getOutgoingQueueInTimeStamp().getUTCInstant(), msg.getOutgoingQueueOutTimeStamp().getUTCInstant()).toMillis() : 0L;
            this.incomingQueueTime = msg.getIncomingQueueInTimeStamp() != null && msg.getIncomingQueueOutTimeStamp() != null ? Duration.between(msg.getIncomingQueueInTimeStamp().getUTCInstant(), msg.getIncomingQueueOutTimeStamp().getUTCInstant()).toMillis() : 0L;
            this.creationToQueueTime = Duration.between(msg.getCCSTimeStamp().getUTCInstant(), msg.getOutgoingQueueInTimeStamp().getUTCInstant()).toMillis();
            this.queueToSerializationTime = Duration.between(msg.getOutgoingQueueOutTimeStamp().getUTCInstant(), msg.getSerializationTime().getUTCInstant()).toMillis();
            this.deserializationToQueueTime = Duration.between(msg.getDoneDeSerializationTime().getUTCInstant(), msg.getIncomingQueueInTimeStamp().getUTCInstant()).toMillis();
            this.queueToReceiveTime = Duration.between(msg.getIncomingQueueOutTimeStamp().getUTCInstant(), received.getUTCInstant()).toMillis();
            this.size = BusTrafficMonitor.sizeOf((Serializable)msg);
            if (msg instanceof StatusMessage) {
                StateBundle sb = ((StatusMessage)msg).getState();
                this.size -= BusTrafficMonitor.sizeOf((Serializable)sb);
            }
        }

        public long getTotalTransferTime() {
            return this.totalTransferTime;
        }

        public long getNetworkTransferTime() {
            return this.networkTransferTime;
        }

        public long getOutboundProcessingTime() {
            return this.outboundProcessingTime;
        }

        public long getInboundProcessingTime() {
            return this.inboundProcessingTime;
        }

        public long getSerializationTime() {
            return this.serializationTime;
        }

        public long getDeserializationTime() {
            return this.deserializationTime;
        }

        public double getSize() {
            return this.size;
        }

        public long getOutgoingQueueTime() {
            return this.outgoingQueueTime;
        }

        public long getIncomingQueueTime() {
            return this.incomingQueueTime;
        }

        public CCSTimeStamp getReceivedTimestamp() {
            return this.received;
        }

        public long getCreationToQueueTime() {
            return this.creationToQueueTime;
        }

        public long getQueueToSerializationTime() {
            return this.queueToSerializationTime;
        }

        public long getDeserializationToQueueTime() {
            return this.deserializationToQueueTime;
        }

        public long getQueueToReceiveTime() {
            return this.queueToReceiveTime;
        }
    }

    private class CommandBusCounterListener
    implements BusMessagePreProcessor {
        private CommandBusCounterListener() {
        }

        public BusMessage preProcessMessage(BusMessage msg) {
            BusTrafficMonitor.this.messageScheduler.schedule(() -> commandQueue.add(() -> BusTrafficMonitor.processBusMessage(Bus.COMMAND, msg, CCSTimeStamp.currentTime())), 0L, TimeUnit.NANOSECONDS);
            return msg;
        }

        public Bus getBus() {
            return Bus.COMMAND;
        }
    }

    private class StatusBusCounterListener
    implements BusMessagePreProcessor {
        private StatusBusCounterListener() {
        }

        public Bus getBus() {
            return Bus.STATUS;
        }

        public BusMessage preProcessMessage(BusMessage msg) {
            BusTrafficMonitor.this.messageScheduler.schedule(() -> statusQueue.add(() -> BusTrafficMonitor.processBusMessage(Bus.STATUS, msg, CCSTimeStamp.currentTime())), 0L, TimeUnit.NANOSECONDS);
            return msg;
        }
    }

    private class LogBusCounterListener
    implements BusMessagePreProcessor {
        private LogBusCounterListener() {
        }

        public Bus getBus() {
            return Bus.LOG;
        }

        public BusMessage preProcessMessage(BusMessage msg) {
            BusTrafficMonitor.this.messageScheduler.schedule(() -> logQueue.add(() -> BusTrafficMonitor.processBusMessage(Bus.LOG, msg, CCSTimeStamp.currentTime())), 0L, TimeUnit.NANOSECONDS);
            return msg;
        }
    }

    private class DoneWork
    implements Runnable {
        private DoneWork() {
        }

        @Override
        public void run() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class MyQueueWorker
    extends Thread {
        private final BlockingQueue<Runnable> queue;

        public MyQueueWorker(BlockingQueue<Runnable> queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            try {
                Runnable r;
                while (!((r = this.queue.take()) instanceof DoneWork)) {
                    r.run();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class Tags {
        private final Bus bus;
        private final AgentInfo agentInfo;
        private final String messageType;

        Tags(Bus bus, AgentInfo agentInfo, BusMessage msg) {
            this.bus = bus;
            this.agentInfo = agentInfo;
            String msgSimpleName = msg.getClass().getSimpleName();
            if (msg instanceof StatusMessage) {
                this.messageType = msgSimpleName;
            } else if (msg instanceof CommandMessage) {
                this.messageType = msg instanceof CommandRequest ? msgSimpleName + "-" + ((CommandRequest)msg).getBasicCommand().getCommand() : msgSimpleName;
            } else if (msg instanceof LogMessage) {
                this.messageType = msgSimpleName + "-" + ((LogMessage)msg).getLoggerName() + "-" + ((LogMessage)msg).getLevel();
            } else {
                throw new RuntimeException("Unknown message " + msg);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof Tags) {
                Tags t1 = (Tags)obj;
                return t1.bus.equals((Object)this.bus) && t1.agentInfo.equals((Object)this.agentInfo) && t1.messageType.equals(this.messageType);
            }
            return false;
        }

        public int hashCode() {
            return this.bus.hashCode() + 34 * this.agentInfo.hashCode() + 123 * this.messageType.hashCode();
        }
    }

    private static class CommandMsg {
        private final MsgInfo msgInfo;
        private MsgInfo ack;

        CommandMsg(MsgInfo msgInfo) {
            this.msgInfo = msgInfo;
        }

        void setAck(MsgInfo ack) {
            this.ack = ack;
        }

        void logCommandMsg(MsgInfo finalReply) {
            Level logLevel;
            long totalCmdExecution = Duration.between(this.msgInfo.msg.getCCSTimeStamp().getUTCInstant(), finalReply.received.getUTCInstant()).toMillis();
            Level level = logLevel = totalCmdExecution > 50L ? Level.INFO : Level.FINE;
            if (this.ack != null) {
                LOG_MSG.log(logLevel, "{0}\n{1}\n{2}\n{3}", new Object[]{BusTrafficMonitor.getMessageInfoStr(this.msgInfo), BusTrafficMonitor.getMessageInfoStr(this.ack), BusTrafficMonitor.getMessageInfoStr(finalReply), "Total Command Execution: " + totalCmdExecution + " ms"});
            } else {
                LOG_MSG.log(logLevel, "{0}\n{1}\n{2}", new Object[]{BusTrafficMonitor.getMessageInfoStr(this.msgInfo), BusTrafficMonitor.getMessageInfoStr(finalReply), "Total Command Execution: " + totalCmdExecution + " ms"});
            }
        }
    }
}

