/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.pfeiffer;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.ascii.TestAscii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.pfeiffer.ASM380;

public class TestASM380
extends TestAscii {
    private final ASM380 mydev;

    public TestASM380() {
        super((Ascii)new ASM380());
        this.mydev = (ASM380)this.dev;
    }

    @Command(description="Show the version string")
    public String showVersion() throws DriverException {
        return this.mydev.getVersion();
    }

    @Command(description="Show the instrument status")
    public String showStatus() throws DriverException {
        return String.format("0x%04x", this.mydev.getStatus());
    }

    @Command(description="Show the decoded instrument status")
    public String showDecodedStatus() throws DriverException {
        String[] status = this.mydev.decodeStatus();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < status.length; ++j) {
            if (j != 0) {
                text.append("\n");
            }
            text.append(status[j]);
        }
        return text.toString();
    }

    @Command(description="Read the inlet pressure")
    public double readInletPressure() throws DriverException {
        return this.mydev.readInletPressure();
    }

    @Command(description="Read the temperature")
    public int readTemperature() throws DriverException {
        return this.mydev.readTemperature();
    }

    @Command(description="Show the primary pump operating hours")
    public int showPrimaryHours() throws DriverException {
        return this.mydev.getPrimaryHours();
    }

    @Command(description="Show the high vacuum pump operating hours")
    public int showHighVacHours() throws DriverException {
        return this.mydev.getHighVacHours();
    }

    @Command(description="Show the stored warning codes")
    public String showWarningCodes() throws DriverException {
        return TestASM380.showCodes(this.mydev.getWarningCodes());
    }

    @Command(description="Show the stored fault codes")
    public String showFaultCodes() throws DriverException {
        return TestASM380.showCodes(this.mydev.getFaultCodes());
    }

    private static String showCodes(int[] codes) {
        if (codes.length == 0) {
            return "No codes stored";
        }
        StringBuilder text = new StringBuilder();
        for (int code : codes) {
            text.append(code).append(" ");
        }
        return text.toString();
    }

    @Command(description="Clear the stored warning codes")
    public void clearWarnings() throws DriverException {
        this.mydev.clearWarnings();
    }

    @Command(description="Clear the stored fault codes")
    public void clearFaults() throws DriverException {
        this.mydev.clearFaults();
    }

    @Command(description="set pump on (true) or off (false)")
    public void pumpOn(boolean on) throws DriverException {
        this.mydev.pumpOn(on);
    }

    @Command(description="get the pumping status")
    public String getPumpStatus() throws DriverException {
        return this.mydev.getPumpStatus();
    }

    @Command(description="enable the alarm (true) or not (false)")
    public void enableAlarm(boolean enable) throws DriverException {
        this.mydev.enableAlarm(enable);
    }

    @Command(description="execute open valve sequence")
    public void openVentValve(boolean open) throws DriverException {
        this.mydev.openVentValve(open);
    }

    @Command(description="get the vent valve status")
    public String getVentValveStatus() throws DriverException {
        return this.mydev.getVentValveStatus();
    }

    @Command(description="get the vent valve actuation parameters")
    public String getVentValveParms() throws DriverException {
        return this.mydev.getVentValveParms();
    }

    @Command(description="set valve opening sequence parameters")
    public void setVentValveParms(@Argument(description="delay before actuation (0->2 secs)") int delay, @Argument(description="time (mmss) in actuated state") int period) throws DriverException {
        this.mydev.setVentValveParms(delay, period);
    }

    @Command(description="set valve opening sequence nominal")
    public void setVentValveNominal() throws DriverException {
        this.mydev.setVentValveNominal();
    }

    @Command(description="Write a command")
    public String writeCommand(@Argument(description="The commmand to send") String command) throws DriverException {
        return this.mydev.writeCommand(command);
    }
}

