import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.bootstrap.BootstrapResourceUtils
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20DiscControl
import org.lsst.ccs.subsystem.common.devices.dataforth.SimMaq20Device
import org.lsst.ccs.subsystem.refrig.ChillerPlcTest
import org.lsst.ccs.subsystem.refrig.ChillerPlutoDevice

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
runMode = props.getProperty("org.lsst.ccs.run.mode", "normal")
if (runMode.equals("simulation")) {
    maq20Device = SimMaq20Device
    plutoDevice = ChillerPlutoDevice
} else {
    maq20Device = Maq20Device
    plutoDevice = ChillerPlutoDevice
}

CCSBuilder builder = ["plctest"]

builder.main (ChillerPlcTest) {

    Pluto (plutoDevice)

    Maq20 (maq20Device, modules: ["DIOL", "DIOL"]) {
        
        Maq20Mod0 (Maq20DiscControl, modIndex: 0)
        
        Maq20Mod1 (Maq20DiscControl, modIndex: 1)
    }

}
