/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.properties;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.indilib.i4j.properties.INDIStandardProperty;

public enum INDIDeviceDescriptor {
    TELESCOPE(INDIDeviceDescriptor.present(INDIStandardProperty.EQUATORIAL_EOD_COORD), INDIDeviceDescriptor.present(INDIStandardProperty.ON_COORD_SET), INDIDeviceDescriptor.present(INDIStandardProperty.TELESCOPE_MOTION_NS), INDIDeviceDescriptor.present(INDIStandardProperty.TELESCOPE_MOTION_WE), INDIDeviceDescriptor.present(INDIStandardProperty.TELESCOPE_TIMED_GUIDE_NS), INDIDeviceDescriptor.present(INDIStandardProperty.TELESCOPE_TIMED_GUIDE_WE), INDIDeviceDescriptor.present(INDIStandardProperty.TELESCOPE_SLEW_RATE), INDIDeviceDescriptor.present(INDIStandardProperty.TELESCOPE_PARK), INDIDeviceDescriptor.present(INDIStandardProperty.TELESCOPE_ABORT_MOTION), INDIDeviceDescriptor.present(INDIStandardProperty.TELESCOPE_TRACK_RATE), INDIDeviceDescriptor.present(INDIStandardProperty.TELESCOPE_INFO), INDIDeviceDescriptor.present(INDIStandardProperty.EQUATORIAL_COORD), INDIDeviceDescriptor.present(INDIStandardProperty.HORIZONTAL_COORD)),
    CCD(INDIDeviceDescriptor.present(INDIStandardProperty.CCDn_FRAME), INDIDeviceDescriptor.present(INDIStandardProperty.CCDn_EXPOSURE), INDIDeviceDescriptor.present(INDIStandardProperty.CCDn_ABORT_EXPOSURE), INDIDeviceDescriptor.present(INDIStandardProperty.CCDn_FRAME), INDIDeviceDescriptor.present(INDIStandardProperty.CCDn_TEMPERATURE), INDIDeviceDescriptor.present(INDIStandardProperty.CCDn_COOLER), INDIDeviceDescriptor.present(INDIStandardProperty.CCDn_COOLER_POWER), INDIDeviceDescriptor.present(INDIStandardProperty.CCDn_FRAME_TYPE), INDIDeviceDescriptor.present(INDIStandardProperty.CCDn_BINNING), INDIDeviceDescriptor.present(INDIStandardProperty.CCDn_COMPRESSION), INDIDeviceDescriptor.present(INDIStandardProperty.CCDn_FRAME_RESET), INDIDeviceDescriptor.present(INDIStandardProperty.CCDn_INFO), INDIDeviceDescriptor.present(INDIStandardProperty.CCDn_CFA), INDIDeviceDescriptor.present(INDIStandardProperty.CCDn)),
    FILTER(INDIDeviceDescriptor.present(INDIStandardProperty.FILTER_SLOT), INDIDeviceDescriptor.present(INDIStandardProperty.FILTER_NAME), INDIDeviceDescriptor.missing(INDIStandardProperty.EQUATORIAL_EOD_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.EQUATORIAL_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.HORIZONTAL_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.CCDn_FRAME)),
    FOCUSER(INDIDeviceDescriptor.present(INDIStandardProperty.ABS_FOCUS_POSITION), INDIDeviceDescriptor.missing(INDIStandardProperty.EQUATORIAL_EOD_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.EQUATORIAL_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.HORIZONTAL_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.CCDn_FRAME)),
    DOME(INDIDeviceDescriptor.present(INDIStandardProperty.DOME_SPEED), INDIDeviceDescriptor.present(INDIStandardProperty.DOME_MOTION), INDIDeviceDescriptor.present(INDIStandardProperty.DOME_TIMER), INDIDeviceDescriptor.present(INDIStandardProperty.REL_DOME_POSITION), INDIDeviceDescriptor.present(INDIStandardProperty.ABS_DOME_POSITION), INDIDeviceDescriptor.present(INDIStandardProperty.DOME_ABORT_MOTION), INDIDeviceDescriptor.present(INDIStandardProperty.DOME_SHUTTER), INDIDeviceDescriptor.present(INDIStandardProperty.DOME_GOTO), INDIDeviceDescriptor.present(INDIStandardProperty.DOME_PARAMS), INDIDeviceDescriptor.present(INDIStandardProperty.DOME_AUTOSYNC), INDIDeviceDescriptor.present(INDIStandardProperty.DOME_MEASUREMENTS)),
    LOCATION(INDIDeviceDescriptor.present(INDIStandardProperty.GEOGRAPHIC_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.EQUATORIAL_EOD_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.EQUATORIAL_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.HORIZONTAL_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.CCDn_FRAME)),
    WEATHER(INDIDeviceDescriptor.present(INDIStandardProperty.ATMOSPHERE), INDIDeviceDescriptor.missing(INDIStandardProperty.EQUATORIAL_EOD_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.EQUATORIAL_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.HORIZONTAL_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.CCDn_FRAME)),
    TIME(INDIDeviceDescriptor.present(INDIStandardProperty.TIME_UTC), INDIDeviceDescriptor.missing(INDIStandardProperty.EQUATORIAL_EOD_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.EQUATORIAL_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.HORIZONTAL_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.CCDn_FRAME)),
    SWITCH(INDIDeviceDescriptor.present(INDIStandardProperty.SWITCH_MODULE), INDIDeviceDescriptor.missing(INDIStandardProperty.EQUATORIAL_EOD_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.EQUATORIAL_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.HORIZONTAL_COORD), INDIDeviceDescriptor.missing(INDIStandardProperty.CCDn_FRAME)),
    UNKNOWN(new Description[0]);

    private final Description[] propertyDescription;

    private Description[] getPropertyDescription() {
        return this.propertyDescription;
    }

    private INDIDeviceDescriptor(Description ... propertyDescription) {
        this.propertyDescription = propertyDescription;
    }

    private static Description present(INDIStandardProperty property) {
        return new Description(property.name(), true);
    }

    private static Description missing(INDIStandardProperty property) {
        return new Description(property.name(), false);
    }

    public static INDIDeviceDescriptor[] detectDeviceType(Collection<String> properties) {
        Set<String> indexedProperties = INDIDeviceDescriptor.unfifyPropertyNames(properties);
        LinkedList<Match> matches = new LinkedList<Match>();
        for (INDIDeviceDescriptor device : INDIDeviceDescriptor.values()) {
            int points = 0;
            for (Description property : device.getPropertyDescription()) {
                if (property.isPresent()) {
                    if (!indexedProperties.contains(property.name)) continue;
                    ++points;
                    continue;
                }
                if (!indexedProperties.contains(property.name)) continue;
                points = Integer.MIN_VALUE;
                break;
            }
            if (points <= 0) continue;
            matches.add(new Match(device, points));
        }
        Collections.sort(matches, new Comparator<Match>(){

            @Override
            public int compare(Match o1, Match o2) {
                return o1.matchPoints - o2.matchPoints;
            }
        });
        INDIDeviceDescriptor[] result = new INDIDeviceDescriptor[matches.size()];
        for (int index = 0; index < result.length; ++index) {
            result[index] = ((Match)matches.get(index)).descriptor;
        }
        return result;
    }

    private static Set<String> unfifyPropertyNames(Collection<String> properties) {
        HashSet<String> indexedProperties = new HashSet<String>();
        for (String string : properties) {
            StringBuffer buffer = new StringBuffer();
            for (char character : string.toCharArray()) {
                if (Character.isDigit(character)) {
                    buffer.append('n');
                    continue;
                }
                buffer.append(Character.toUpperCase(character));
            }
            indexedProperties.add(buffer.toString());
        }
        return indexedProperties;
    }

    private static class Match {
        private final INDIDeviceDescriptor descriptor;
        private final int matchPoints;

        public Match(INDIDeviceDescriptor descriptor, int matchPoints) {
            this.descriptor = descriptor;
            this.matchPoints = matchPoints;
        }
    }

    private static final class Description {
        private final boolean present;
        private final String name;

        private boolean isPresent() {
            return this.present;
        }

        private Description(String name, boolean present) {
            this.name = name;
            this.present = present;
        }
    }
}

