/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.protocol.websocket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.glassfish.tyrus.client.ClientManager;
import org.indilib.i4j.protocol.api.INDIConnection;
import org.indilib.i4j.protocol.api.INDIInputStream;
import org.indilib.i4j.protocol.api.INDIOutputStream;
import org.indilib.i4j.protocol.url.INDIURLStreamHandlerFactory;
import org.indilib.i4j.protocol.websocket.INDIWebSocketConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INDIWebsocketURLConnection
extends URLConnection
implements INDIConnection {
    private static final Logger LOG;
    private INDIWebSocketConnection socketConnection;

    protected INDIWebsocketURLConnection(URL url) {
        super(url);
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this.socketConnection == null) {
            try {
                ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().build();
                ClientManager client = ClientManager.createClient();
                Session session = client.connectToServer(new Endpoint(){

                    public void onOpen(Session session, EndpointConfig config) {
                        INDIWebsocketURLConnection.this.socketConnection = new INDIWebSocketConnection(session);
                    }
                }, cec, new URI(this.getURL().toExternalForm().replace("indiw:", "ws:")));
                this.socketConnection = new INDIWebSocketConnection(session);
            }
            catch (Exception e) {
                LOG.error("could not connect to websocket", (Throwable)e);
            }
        }
    }

    @Override
    public INDIInputStream getINDIInputStream() throws IOException {
        return this.getSocketConnection().getINDIInputStream();
    }

    @Override
    public INDIOutputStream getINDIOutputStream() throws IOException {
        return this.getSocketConnection().getINDIOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return (InputStream)((Object)this.getINDIInputStream());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return (OutputStream)((Object)this.getINDIOutputStream());
    }

    private INDIConnection getSocketConnection() throws IOException {
        this.connect();
        return this.socketConnection;
    }

    @Override
    public void close() throws IOException {
        if (this.socketConnection != null) {
            this.socketConnection.close();
        }
    }

    static {
        INDIURLStreamHandlerFactory.init();
        LOG = LoggerFactory.getLogger(INDIWebsocketURLConnection.class);
    }
}

