/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Logging;
import org.lsst.ccs.subsystem.shutter.statemachine.Prod;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleState;

class Opening
extends SimpleState<Prod> {
    private static final Logger LOG = Logger.getLogger(Opening.class.getName());

    public Opening(Prod context) {
        super(context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void entry() {
        Logging.logEntry(this);
        ((Prod)this.getContext()).getActions().setSoftwareState(SoftwareState.OPENING);
        ((Prod)this.getContext()).getActions().setPhysicalState(PhysicalState.OPENING);
    }

    @Override
    public void timer(Channel<EventReply> chan) throws InterruptedException {
        Logging.logEvent(this);
        chan.write(PromptReply.ACCEPTED);
        Prod ctx = (Prod)this.getContext();
        ctx.makeTransition(ctx.getTravelingState(), null);
    }

    @Override
    public void motionDone(Channel<EventReply> chan, MotionDonePLC profileData) throws InterruptedException {
        Logging.logEvent(this);
        chan.write(PromptReply.ACCEPTED);
        Prod ctx = (Prod)this.getContext();
        ctx.makeTransition(ctx.getOpenedState(), () -> ctx.getActions().sendProfile(profileData));
    }
}

