/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.logging.Logger;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;

public class CanOpenDAC
extends CanOpenDevice {
    private static final Logger FCSLOG = Logger.getLogger(CanOpenDAC.class.getName());
    public static final double bitOverVolts = 3210.27287;

    public void writeAnalogOutput(int inputNB, int value) {
        if (inputNB < 1 || inputNB > 4) {
            throw new IllegalArgumentException("CAN-CBX-AO412 : input has to be 1..4");
        }
        if (!this.isBooted()) {
            String message = String.format("DAC %s / nodeID=%s is NOT BOOTED", this.name, this.nodeID);
            FCSLOG.severe(message);
            throw new HardwareNotDetectedException("CanOpenDAC is MISSING", this.name, this.nodeID, this.serialNB);
        }
        this.writeSDO(25617, inputNB, 2, value);
    }
}

