/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Segment;

public class WavefrontCCD
extends CCD {
    private final WavefrontType sensorType;

    WavefrontCCD(CCDType ccdType, WavefrontType guiderType) {
        super(1, 8, ccdType);
        this.sensorType = guiderType;
    }

    @Override
    public String getName() {
        return this.sensorType.getName();
    }

    @Override
    public void addChildGeometry(Segment child, int p, int s) {
        super.addChildGeometry(child, p, s);
        child.setParallelPosition(p + 1);
    }

    public static WavefrontCCD createWavefrontCCD(CCDType ccdType, WavefrontType wavefrontType) {
        WavefrontCCD ccd = new WavefrontCCD(ccdType, wavefrontType);
        int p = 0;
        for (int s = 0; s < ccd.getSerialChildrenCount(); ++s) {
            int channel = s + 1;
            Segment segment = Segment.createCCDSegment(ccdType, channel);
            ccd.addChildGeometry(segment, p, s);
        }
        return ccd;
    }

    public WavefrontType getWavefrontType() {
        return this.sensorType;
    }

    public static enum WavefrontType {
        WF0("SW0"),
        WF1("SW1");

        private final String name;

        private WavefrontType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

