/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.refrig.constants.CompressorState;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.SwCondState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.ColdCompState;
import org.lsst.ccs.subsystem.refrig.data.CryoCompState;

@SkipEncoding
public class CompState
implements Serializable {
    public static final String KEY = "CompressorState";
    private final int type;
    private final Collection validSwitches;
    private final Collection validLatches;
    private final Collection validConditions;
    private final Collection validSwConditions;
    private String name;
    private int index;
    private CompressorState compState = CompressorState.OFFLINE;
    private final SwitchState[] switchState = new SwitchState[8];
    private final LatchState[] latchState = new LatchState[10];
    private final ConditionState[] conditionState = new ConditionState[18];
    private final SwCondState[] swCondState = new SwCondState[14];
    private static final long serialVersionUID = 4047727105819432833L;

    public CompState(int type) {
        this.type = type;
        this.validSwitches = type == 0 ? ColdCompState.SWITCHES : CryoCompState.SWITCHES;
        this.validLatches = type == 0 ? ColdCompState.LATCHES : CryoCompState.LATCHES;
        this.validConditions = type == 0 ? ColdCompState.CONDITIONS : CryoCompState.CONDITIONS;
        this.validSwConditions = type == 0 ? ColdCompState.SW_CONDITIONS : CryoCompState.SW_CONDITIONS;
        Arrays.fill((Object[])this.switchState, (Object)SwitchState.OFFLINE);
        Arrays.fill((Object[])this.latchState, (Object)LatchState.OFFLINE);
        Arrays.fill((Object[])this.conditionState, (Object)ConditionState.OFF);
        Arrays.fill((Object[])this.swCondState, (Object)SwCondState.CLEAR);
    }

    public int getType() {
        return this.type;
    }

    public Collection<Integer> getValidSwitches() {
        return this.validSwitches;
    }

    public Collection<Integer> getValidLatches() {
        return this.validLatches;
    }

    public Collection<Integer> getValidConditions() {
        return this.validConditions;
    }

    public Collection<Integer> getValidSwConditions() {
        return this.validSwConditions;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setCompressorState(CompressorState value) {
        this.compState = value;
    }

    public CompressorState getCompressorState() {
        return this.compState;
    }

    public void setSwitchState(int sw, SwitchState state) {
        this.switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return this.switchState[sw];
    }

    public void setLatchState(int latch, LatchState state) {
        this.latchState[latch] = state;
    }

    public LatchState getLatchState(int latch) {
        return this.latchState[latch];
    }

    public void setConditionState(int cond, ConditionState state) {
        this.conditionState[cond] = state;
    }

    public ConditionState getConditionState(int cond) {
        return this.conditionState[cond];
    }

    public void setSwConditionState(int cond, SwCondState state) {
        this.swCondState[cond] = state;
    }

    public SwCondState getSwConditionState(int cond) {
        return this.swCondState[cond];
    }

    public String toString() {
        return super.toString();
    }
}

