/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAccelerometer;
import org.lsst.ccs.subsystems.fcs.common.AcceleroInterface;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;

public class CanOpenMG550P
extends CanOpenDevice
implements AcceleroInterface {
    protected int cobid1;
    protected int cobid2;
    private long pdo1 = 0L;
    private long pdo2 = 0L;
    public static final double ANGULARVELOCITY_CF = 0.008;
    public static final double ACCELERATION_CF = 0.2;
    private double[] angularVelocities = new double[3];
    private double[] accelerations = new double[3];
    private double gravity = 1.0;
    private double elevation = 1.0;
    private double azimut = 0.0;
    private double airmass = 1.0;

    @Override
    public double getAirmass() {
        return this.airmass;
    }

    public double[] getAngularVelocities() {
        return this.angularVelocities;
    }

    public double[] getAccelerations() {
        return this.accelerations;
    }

    @Override
    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByAccelerometer.class, this.path);
    }

    @Override
    public void init() {
        this.cobid1 = this.nodeID + 384;
        this.cobid2 = this.nodeID + 640;
    }

    @Override
    public void doInitializePDOs() throws DriverException {
        this.tcpProxy.addReceivedPDO(this.cobid1);
        this.tcpProxy.addReceivedPDO(this.cobid2);
    }

    @Override
    public void updateFromPDO(PDOData pdo) {
        int i;
        FCSCst.FCSLOG.debug((Object)(this.name + " updatingFromPDO = " + pdo));
        boolean updated = false;
        if (pdo.getPDOs().containsKey(this.cobid1)) {
            this.pdo1 = (Long)pdo.getPDOs().get(this.cobid1);
            updated = true;
            FCSCst.FCSLOG.debug((Object)(this.name + " updatingFromPDO1 = " + this.pdo1 + " binaire:" + Long.toBinaryString(this.pdo1)));
            for (i = 0; i < 3; ++i) {
                this.angularVelocities[i] = (double)CanOpenMG550P.extractValue(this.pdo1, i) * 0.008;
            }
        }
        if (pdo.getPDOs().containsKey(this.cobid2)) {
            this.pdo2 = (Long)pdo.getPDOs().get(this.cobid2);
            updated = true;
            FCSCst.FCSLOG.debug((Object)(this.name + " updatingFromPDO2 = " + this.pdo2 + " binaire:" + Long.toBinaryString(this.pdo2)));
            for (i = 0; i < 3; ++i) {
                this.accelerations[i] = (double)CanOpenMG550P.extractValue(this.pdo2, i) * 0.2;
            }
            this.computeAirmass();
        }
        if (updated) {
            this.publishDataAccelero();
        }
    }

    public double computeGravity() {
        double sq = 0.0;
        for (int i = 0; i < 3; ++i) {
            sq += Math.pow(this.accelerations[i], 2.0);
        }
        return Math.sqrt(sq) / 1000.0;
    }

    private double computeAzimut(double x, double y) {
        double az = x == 0.0 ? 90.0 : Math.toDegrees(Math.atan(Math.abs(y / x)));
        if (x < 0.0) {
            az = 180.0 - az;
        }
        if (y < 0.0) {
            az = 360.0 - az;
        }
        return az;
    }

    public void computeAirmass() {
        this.gravity = this.computeGravity();
        double x = this.accelerations[0] / 1000.0;
        double y = this.accelerations[1] / 1000.0;
        double z = this.accelerations[2] / 1000.0;
        if (this.gravity >= 0.5 && this.gravity <= 1.5) {
            this.elevation = Math.toDegrees(Math.asin(-z / this.gravity));
            this.azimut = this.computeAzimut(x, y);
            this.airmass = Math.abs(z) < 0.1 ? 100.0 : -this.gravity / z;
        } else {
            FCSCst.FCSLOG.warning((Object)(this.name + " gravity = " + this.gravity + " => should be between 1.5 and 1.5 default values are taken."));
            this.gravity = 1.0;
            this.elevation = 90.0;
            this.azimut = 0.0;
            this.airmass = 1.0;
        }
        FCSCst.FCSLOG.debug((Object)(this.name + " gravity = " + this.gravity));
        FCSCst.FCSLOG.debug((Object)(this.name + " elevation = " + this.elevation));
        FCSCst.FCSLOG.debug((Object)(this.name + " azimut = " + this.azimut));
        FCSCst.FCSLOG.debug((Object)(this.name + " airmass = " + this.airmass));
    }

    @Override
    public String printSerialNumber() {
        return Integer.toHexString((int)this.readSDO(4096, 0));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="print values updated by PDOs to debug and test")
    public String printAngularVelocities() {
        StringBuilder sb = new StringBuilder("=> pdo1 value = ");
        sb.append(this.pdo1);
        sb.append(" / pdo1 = 0x").append(Long.toHexString(this.pdo1));
        sb.append(" / pdo1 = 0b").append(Long.toBinaryString(this.pdo1));
        for (int i = 0; i < 3; ++i) {
            sb.append("\n angularVelocity axe i=").append(i).append(" => ");
            sb.append(this.angularVelocities[i]);
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="print values updated by PDOs to debug and test")
    public String printAccelerations() {
        StringBuilder sb = new StringBuilder("=> pdo2 value = ");
        sb.append(this.pdo2);
        sb.append(" = 0x").append(Long.toHexString(this.pdo2));
        sb.append(" = 0b").append(Long.toBinaryString(this.pdo2));
        for (int i = 0; i < 3; ++i) {
            sb.append("\n acceleration axe i=").append(i).append(" => ");
            sb.append(this.accelerations[i]);
        }
        return sb.toString();
    }

    public static short extractValue(long pdo, int axe) {
        switch (axe) {
            case 0: {
                return (short)(pdo >> 16 & 0xFFFFL);
            }
            case 1: {
                return (short)(pdo >> 32 & 0xFFFFL);
            }
            case 2: {
                return (short)(pdo >> 48 & 0xFFFFL);
            }
        }
        assert (false) : axe;
        return 0;
    }

    public void publishDataAccelero() {
        KeyValueData kvd = new KeyValueData(this.path, (Serializable)this.createStatusDataPublishedByAccelerometer());
        this.subs.publishSubsystemDataOnStatusBus(kvd);
    }

    public StatusDataPublishedByAccelerometer createStatusDataPublishedByAccelerometer() {
        StatusDataPublishedByAccelerometer status = new StatusDataPublishedByAccelerometer(this.isBooted(), this.isInitialized());
        status.setAccelerationX(this.accelerations[0]);
        status.setAccelerationY(this.accelerations[1]);
        status.setAccelerationZ(this.accelerations[2]);
        status.setAngularVelocityX(this.angularVelocities[0]);
        status.setAngularVelocityY(this.angularVelocities[1]);
        status.setAngularVelocityZ(this.angularVelocities[2]);
        status.setAirmass(this.airmass);
        status.setAzimut(this.azimut);
        status.setElevation(this.elevation);
        status.setGravity(this.gravity);
        return status;
    }
}

