/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;

class CommandExecutor {
    private static final Logger LOG = Logger.getLogger(CommandExecutor.class.getName());
    private static final Pattern TELEMETRY_PATTERN = Pattern.compile("Telemetry\\:\\s*(.*)\\:\\s*(.*)");
    private static final Pattern SLOT_PATTERN = Pattern.compile(".*_S(.*)\\.fits");
    private final ImageHandlingConfig config;
    private final Queue<Process> runningProcesses = new ConcurrentLinkedQueue<Process>();
    private final Agent agent;

    CommandExecutor(ImageHandlingConfig config, Agent agent) {
        this.config = config;
        this.agent = agent;
    }

    void execute(FileList fileList, Map<String, String> env) {
        for (File file : fileList) {
            this.execute(file, env);
        }
    }

    void execute(File fitsFile, Map<String, String> env) {
        List<String> commands = this.config.getCommands();
        List<String> command = List.of("/bin/bash", "-c", commands.stream().collect(Collectors.joining(";")));
        String date = env.getOrDefault("DATE", "UNKNOWN");
        File logFileDir = new File(this.config.getLogDirectory(), date);
        File logFile = new File(logFileDir, fitsFile.getName() + ".log");
        Matcher matcher = SLOT_PATTERN.matcher(fitsFile.getName());
        String slot = matcher.matches() ? "S" + matcher.group(1) : "S??";
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.environment().putAll(this.config.getEnvironment());
        processBuilder.environment().putAll(env);
        processBuilder.environment().put("LOGFILE", logFile.getAbsolutePath());
        processBuilder.environment().put("FITSFILE", fitsFile.getAbsolutePath());
        processBuilder.environment().put("SLOT", slot);
        processBuilder.directory(this.config.getCurrentDirectory());
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectOutput(logFile);
        try {
            Files.createDirectories(logFileDir.toPath(), new FileAttribute[0]);
            Process process = processBuilder.start();
            this.runningProcesses.add(process);
            LOG.log(Level.INFO, () -> String.format("Process for file %s started", fitsFile));
            process.onExit().thenAccept(p -> {
                this.runningProcesses.remove(p);
                int rc = p.exitValue();
                if (rc != 0) {
                    LOG.log(Level.WARNING, () -> String.format("Process for file %s terminated with non-zero return code %d", fitsFile, rc));
                } else {
                    LOG.log(Level.INFO, () -> String.format("Process for file %s complete", fitsFile));
                    String raft = processBuilder.environment().getOrDefault("RAFT", "R??");
                    KeyValueDataList keyValueDataList = this.scanFileForTelemetry(logFile, "scripts/" + raft + "/" + slot);
                    if (!keyValueDataList.getListOfKeyValueData().isEmpty()) {
                        this.agent.publishSubsystemDataOnStatusBus((KeyValueData)keyValueDataList);
                    }
                }
            });
        }
        catch (IOException x) {
            LOG.log(Level.WARNING, "Unable to create process for file " + fitsFile, x);
        }
    }

    private KeyValueDataList scanFileForTelemetry(File logFile, String root) {
        KeyValueDataList kvdl = new KeyValueDataList("");
        try (BufferedReader in = Files.newBufferedReader(logFile.toPath());){
            String line;
            while ((line = in.readLine()) != null) {
                Matcher matcher = TELEMETRY_PATTERN.matcher(line);
                if (!matcher.matches()) continue;
                String key = matcher.group(1);
                String valueStr = matcher.group(2);
                double value = Double.NaN;
                try {
                    value = Double.valueOf(valueStr);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
                if (key.startsWith("/")) {
                    kvdl.addData(key, (Serializable)Double.valueOf(value));
                    continue;
                }
                kvdl.addData(root + "/" + key, (Serializable)Double.valueOf(value));
            }
        }
        catch (IOException x) {
            LOG.log(Level.WARNING, "IO Error scanning log file: " + logFile, x);
        }
        return kvdl;
    }
}

