/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.client;

import org.indilib.i4j.INDIException;
import org.indilib.i4j.client.INDIElement;
import org.indilib.i4j.client.INDIElementListener;
import org.indilib.i4j.client.INDITextProperty;
import org.indilib.i4j.client.INDIValueException;
import org.indilib.i4j.client.INDIViewCreator;
import org.indilib.i4j.protocol.DefElement;
import org.indilib.i4j.protocol.DefText;
import org.indilib.i4j.protocol.OneElement;
import org.indilib.i4j.protocol.OneText;

public class INDITextElement
extends INDIElement {
    private String value;
    private String desiredValue = null;
    private INDIElementListener uiComponent;

    protected INDITextElement(DefText xml, INDITextProperty property) {
        super((DefElement<?>)xml, property);
        this.value = xml.getTextContent();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    protected void setValue(OneElement<?> xml) {
        this.value = xml.getTextContent();
        this.notifyListeners();
    }

    @Override
    public INDIElementListener getDefaultUIComponent() throws INDIException {
        if (this.uiComponent != null) {
            this.removeINDIElementListener(this.uiComponent);
        }
        this.uiComponent = INDIViewCreator.getDefault().createTextElementView(this, this.getProperty().getPermission());
        this.addINDIElementListener(this.uiComponent);
        return this.uiComponent;
    }

    @Override
    public boolean checkCorrectValue(Object valueToCheck) throws INDIValueException {
        if (valueToCheck == null) {
            throw new INDIValueException(this, "null value");
        }
        return valueToCheck instanceof String;
    }

    @Override
    public String getNameAndValueAsString() {
        return this.getName() + " - " + this.getValue();
    }

    @Override
    public String getDesiredValue() {
        return this.desiredValue;
    }

    @Override
    public void setDesiredValue(Object desiredValue) throws INDIValueException {
        String v = null;
        try {
            v = (String)desiredValue;
        }
        catch (ClassCastException e) {
            throw new INDIValueException(this, "Value for a Text Element must be a String");
        }
        this.desiredValue = v;
    }

    @Override
    public boolean isChanged() {
        return this.desiredValue != null;
    }

    @Override
    protected OneElement<?> getXMLOneElementNewValue() {
        OneText xml = (OneText)((OneText)new OneText().setName(this.getName())).setTextContent(this.desiredValue);
        this.desiredValue = null;
        return xml;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }
}

