/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.errors.MinioException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;

public class S3FileUploaderAndDeleter {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String writeToS3(AdditionalFile adFile, String[] credentials, String minioURL, String myBucket, String config) throws IOException {
        try {
            MinioClient minioClient = MinioClient.builder().endpoint(minioURL).credentials(credentials[0], credentials[1]).build();
            boolean found = minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(myBucket)).build());
            if (!found) {
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(myBucket)).build());
            }
            try (ByteArrayOutputStream boutstream = new ByteArrayOutputStream();){
                String string;
                boutstream.write(adFile.toString().getBytes());
                try (ByteArrayInputStream binstream = new ByteArrayInputStream(boutstream.toByteArray());){
                    String myFileNameAndPath = config + "/" + adFile.getFileType() + "/" + adFile.getFileName();
                    minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(myBucket)).object(myFileNameAndPath)).stream((InputStream)binstream, (long)binstream.available(), -1L).build());
                    string = minioURL + "/" + myBucket + "/" + config + "/" + adFile.getFileType() + "/" + adFile.getObsId().getDateString() + "/" + adFile.getFileName();
                }
                return string;
            }
        }
        catch (MinioException | InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new IOException("Unable to write s3 file", ex);
        }
    }

    public static void deleteFromS3(String[] credentials, String minioURL, String myBucket, String myFileNameAndPath) throws IOException {
        try {
            MinioClient minioClient = MinioClient.builder().endpoint(minioURL).credentials(credentials[0], credentials[1]).build();
            boolean found = minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(myBucket)).build());
            if (!found) {
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(myBucket)).build());
            }
            minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(myBucket)).object(myFileNameAndPath)).build());
        }
        catch (MinioException | InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new IOException("Unable to delete s3 file", ex);
        }
    }
}

