/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;

public class AdditionalFileToLFAEvent {
    private final LargeFileObjectAvailableEvent lfaEvent;
    private final Long cksum;
    private final Long byteSize;

    public AdditionalFileToLFAEvent(AdditionalFile addFile, String url) {
        CountOutputStream cnos = new CountOutputStream();
        CRC32 cksum32 = new CRC32();
        CheckedOutputStream cos = new CheckedOutputStream(cnos, cksum32);
        try {
            addFile.writeFile((OutputStream)cos);
            System.out.println(cnos.toString());
        }
        catch (IOException ex) {
            Logger.getLogger(OCSBridge.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.byteSize = cnos.getByteCount();
        this.cksum = cos.getChecksum().getValue();
        float lfaVersion = 1.0f;
        this.lfaEvent = new LargeFileObjectAvailableEvent(url, "string:generator", lfaVersion, this.byteSize.intValue(), this.cksum.toString(), "mimetype", addFile.getFileName());
    }

    LargeFileObjectAvailableEvent getlfaEvent() {
        return this.lfaEvent;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public long getChecksum() {
        return this.cksum;
    }

    class CountOutputStream
    extends OutputStream {
        long byteCount = 0L;

        CountOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ++this.byteCount;
        }

        long getByteCount() {
            return this.byteCount;
        }
    }
}

