# FCS scripts

This is a list of scripts made for tests or to perform specific actions that are complex using the CCS console.

## Configuration

### `configureAutochangerPDOs.py`

Writes the PDO mapping or disables the PDO for the autochanger. Can be used with  `<subsystem_name>` = `fcs`, `fcs-proto`, `autochanger1` or `autochanger2`

**Mapping**  
`ccs-script configureAutochangerPDOs.py -s <subsystem_name>`

**Disabling**  
`ccs-script configureAutochangerPDOs.py -s <subsystem_name> --disable`  

 ### `printPdoConfiguration.py`

 Displays the current PDO configuration for a given node ID

`ccs-script printPdoConfiguration.py -s <subsystem_name> -n <node_id>`  

where `<subsystem_name>` = `fcs`, `fcs-proto`, `autochanger1` or `autochanger2`  
and `<node_id>` corresponds to the controller node ID like 0x2a or 0x31

### `carouselEPOSControllerCheck.py`


## Move sequences

### `discoverAllFiltersID.py`

The sequence uses the autochanger ID sensor to discover sequentially which filters are stored in all five carousel sockets. The result is printed in the console.

`ccs-script discoverAllFiltersID.py`

### `setFilterSequenceAtSLAC.py`

Execute a series of filter exchanges using all available sockets. The order of picked sockets can be turned random, and the sequence can be repeated a number of times.

`ccs-script setFilterSequenceAtSLAC.py -n <n_seq> --random`

where `<n_seq>` is the number of sequences and the `--random` flag can be put for the sockets to be chosen in a random order.

### `fcsSetFilterSequence.py`

### `autochangerMoveAndClampSequence.py`

### `carouselRotationSequence.py`

### ...

The list is incomplete but the more recent scripts are described above.
