/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.client;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.indilib.i4j.Constants;
import org.indilib.i4j.INDIException;
import org.indilib.i4j.client.INDIBLOBElement;
import org.indilib.i4j.client.INDIBLOBProperty;
import org.indilib.i4j.client.INDIDevice;
import org.indilib.i4j.client.INDIDeviceListener;
import org.indilib.i4j.client.INDIElement;
import org.indilib.i4j.client.INDIElementListener;
import org.indilib.i4j.client.INDILightElement;
import org.indilib.i4j.client.INDILightProperty;
import org.indilib.i4j.client.INDINumberElement;
import org.indilib.i4j.client.INDINumberProperty;
import org.indilib.i4j.client.INDIProperty;
import org.indilib.i4j.client.INDIPropertyListener;
import org.indilib.i4j.client.INDISwitchElement;
import org.indilib.i4j.client.INDISwitchProperty;
import org.indilib.i4j.client.INDITextElement;
import org.indilib.i4j.client.INDITextProperty;
import org.indilib.i4j.client.INDIViewCreatorInterface;

public final class INDIViewCreator {
    private static final DummyDeviceListener DUMMY_DEVICE_LISTENER = new DummyDeviceListener();
    private static final DummyPropertyListener DUMMY_PROPERTY_LISTENER = new DummyPropertyListener();
    private static final DummyElementListener DUMMY_ELEMENT_LISTENER = new DummyElementListener();
    private static INDIViewCreatorInterface creatorInterface;

    private INDIViewCreator() {
    }

    public static INDIViewCreatorInterface getDefault() {
        if (creatorInterface == null) {
            ServiceLoader<INDIViewCreatorInterface> loader = ServiceLoader.load(INDIViewCreatorInterface.class);
            Iterator<INDIViewCreatorInterface> iterator = loader.iterator();
            if (iterator.hasNext()) {
                creatorInterface = iterator.next();
            }
            if (creatorInterface == null) {
                creatorInterface = new DummyViewCreator();
            }
        }
        return creatorInterface;
    }

    private static final class DummyPropertyListener
    implements INDIPropertyListener {
        private DummyPropertyListener() {
        }

        @Override
        public void propertyChanged(INDIProperty<?> property) {
        }
    }

    private static final class DummyElementListener
    implements INDIElementListener {
        private DummyElementListener() {
        }

        @Override
        public void elementChanged(INDIElement element) {
        }
    }

    private static final class DummyDeviceListener
    implements INDIDeviceListener {
        private DummyDeviceListener() {
        }

        @Override
        public void removeProperty(INDIDevice device, INDIProperty<?> property) {
        }

        @Override
        public void newProperty(INDIDevice device, INDIProperty<?> property) {
        }

        @Override
        public void messageChanged(INDIDevice device) {
        }
    }

    private static final class DummyViewCreator
    implements INDIViewCreatorInterface {
        private DummyViewCreator() {
        }

        @Override
        public INDIPropertyListener createTextPropertyView(INDITextProperty indiProperty) throws INDIException {
            return DUMMY_PROPERTY_LISTENER;
        }

        @Override
        public INDIElementListener createTextElementView(INDITextElement indiTextElement, Constants.PropertyPermissions permission) throws INDIException {
            return DUMMY_ELEMENT_LISTENER;
        }

        @Override
        public INDIPropertyListener createSwitchPropertyView(INDISwitchProperty indiProperty) throws INDIException {
            return DUMMY_PROPERTY_LISTENER;
        }

        @Override
        public INDIElementListener createSwitchElementView(INDISwitchElement indiSwitchElement, Constants.PropertyPermissions permission) throws INDIException {
            return DUMMY_ELEMENT_LISTENER;
        }

        @Override
        public INDIPropertyListener createNumberPropertyView(INDINumberProperty indiProperty) throws INDIException {
            return DUMMY_PROPERTY_LISTENER;
        }

        @Override
        public INDIElementListener createNumberElementView(INDINumberElement indiNumberElement, Constants.PropertyPermissions permission) throws INDIException {
            return DUMMY_ELEMENT_LISTENER;
        }

        @Override
        public INDIPropertyListener createLightPropertyView(INDILightProperty indiProperty) throws INDIException {
            return DUMMY_PROPERTY_LISTENER;
        }

        @Override
        public INDIElementListener createLightElementView(INDILightElement indiLightElement, Constants.PropertyPermissions permission) throws INDIException {
            return DUMMY_ELEMENT_LISTENER;
        }

        @Override
        public INDIDeviceListener createDeviceListener(INDIDevice indiDevice) throws INDIException {
            return DUMMY_DEVICE_LISTENER;
        }

        @Override
        public INDIPropertyListener createBlobPropertyView(INDIBLOBProperty indiProperty) throws INDIException {
            return DUMMY_PROPERTY_LISTENER;
        }

        @Override
        public INDIElementListener createBlobElementView(INDIBLOBElement indiblobElement, Constants.PropertyPermissions permission) throws INDIException {
            return DUMMY_ELEMENT_LISTENER;
        }

        @Override
        public INDIDeviceListener createDeviceView(INDIDevice indiDevice) throws INDIException {
            return DUMMY_DEVICE_LISTENER;
        }
    }
}

