/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.cluster.monitor;

class Accumulate {
    private double accum = 0.0;
    private double min = Double.MAX_VALUE;
    private double max = -1.7976931348623157E308;
    private int counter = 0;

    Accumulate() {
    }

    public synchronized void accumulate(double value) {
        this.accum += value;
        ++this.counter;
        if (value > this.max) {
            this.max = value;
        }
        if (value < this.min) {
            this.min = value;
        }
    }

    public double getAverageValue() {
        return this.counter > 0 ? this.accum / (double)this.counter : Double.NaN;
    }

    public double getMaxValue() {
        return this.counter > 0 ? this.max : Double.NaN;
    }

    public double getMinValue() {
        return this.counter > 0 ? this.min : Double.NaN;
    }

    public double getTotalValue() {
        return this.accum;
    }

    public int getCounts() {
        return this.counter;
    }
}

